/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.blocks.BrazierBlock;
import com.lion.graveyard.entities.HostileGraveyardEntity;
import com.lion.graveyard.init.TGAdvancements;
import com.lion.graveyard.init.TGSounds;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WraithEntity
extends HostileGraveyardEntity
implements GeoEntity {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final UUID ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", 0.2, AttributeModifier.Operation.ADDITION);
    private final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private final RawAnimation SPAWN_ANIMATION = RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation MOVE_ANIMATION = RawAnimation.begin().then("moving", Animation.LoopType.LOOP);
    private final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attacking", Animation.LoopType.LOOP);
    protected final byte ANIMATION_SPAWN = 0;
    protected final byte ANIMATION_IDLE = 1;
    protected final byte ANIMATION_DEATH = (byte)2;
    protected final byte ANIMATION_ATTACK = (byte)3;
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(WraithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private boolean spawned = false;
    private int spawnTimer;
    @Nullable
    private BlockPos homePosition;
    private int timeSinceExtinguish;

    public WraithEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world, "wraith");
        this.f_21342_ = new FlyingMoveControl((Mob)this, 0, true);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public void m_6478_(MoverType movementType, Vec3 movement) {
        super.m_6478_(movementType, movement);
        this.m_20101_();
    }

    public void m_7601_(BlockState state, Vec3 multiplier) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, multiplier);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WraithMeleeGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new ExtinguishGoal());
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        birdNavigation.m_26440_(false);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26443_(true);
        return birdNavigation;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            Entity entity = source.m_7640_();
            if (entity instanceof Arrow) {
                return false;
            }
            return super.m_6469_(source, amount);
        }
        return super.m_6469_(source, amount);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION, (Object)1);
        this.spawnTimer = 20;
        this.setAnimation((byte)0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(true);
        if (this.getHomePosition() == null) {
            this.homePosition = this.m_20183_();
        }
        if (this.f_19796_.m_188501_() < 0.025f) {
            this.addParticles();
        }
    }

    private BlockPos getHomePosition() {
        return this.homePosition;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.homePosition != null) {
            nbt.m_128405_("BoundX", this.homePosition.m_123341_());
            nbt.m_128405_("BoundY", this.homePosition.m_123342_());
            nbt.m_128405_("BoundZ", this.homePosition.m_123343_());
        }
        nbt.m_128405_("timeSinceExtinguish", this.timeSinceExtinguish);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("BoundX")) {
            this.homePosition = new BlockPos(nbt.m_128451_("BoundX"), nbt.m_128451_("BoundY"), nbt.m_128451_("BoundZ"));
        }
        this.timeSinceExtinguish = nbt.m_128451_("timeSinceExtinguish");
    }

    @Override
    public void m_8107_() {
        --this.spawnTimer;
        if (this.m_20193_().m_5776_() && this.spawnTimer >= 0 && this.spawned) {
            this.addParticles();
        }
        AttributeInstance entityAttributeInstance = this.m_21051_(Attributes.f_22280_);
        if (!this.m_5912_()) {
            entityAttributeInstance.m_22130_(ATTACKING_SPEED_BOOST);
        } else if (!entityAttributeInstance.m_22109_(ATTACKING_SPEED_BOOST)) {
            entityAttributeInstance.m_22118_(ATTACKING_SPEED_BOOST);
        }
        if (!this.m_6084_()) {
            this.addDeathParticles();
        }
        super.m_8107_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        world.m_5594_(null, this.m_20183_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 2.0f, -5.0f);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 42 && !this.m_20193_().m_5776_()) {
            this.m_20193_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void addParticles() {
        this.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_() + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()), this.m_20186_(), this.m_20189_() + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()), 0.0, (double)0.05f, 0.0);
    }

    private void addDeathParticles() {
        for (int i = 0; i < 10; ++i) {
            this.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()), this.m_20186_() + 1.0, this.m_20189_() + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()), 0.0, (double)0.05f, 0.0);
        }
    }

    int getTimeSinceExtinguish() {
        return this.timeSinceExtinguish;
    }

    void addExtinguishCounter() {
        ++this.timeSinceExtinguish;
    }

    @VisibleForDebug
    public boolean hasHomePosition() {
        return this.homePosition != null;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268490_) || damageSource.m_269533_(DamageTypeTags.f_268437_) || damageSource.m_269533_(DamageTypeTags.f_276146_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public static AttributeSupplier.Builder createWraithAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 27.5).m_22268_(Attributes.f_22281_, 6.5).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22280_, 0.35);
    }

    public byte getAnimation() {
        return (Byte)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, event -> {
            boolean isMoving;
            AnimationController controller = event.getController();
            float limbSwingAmount = event.getLimbSwingAmount();
            boolean bl = isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
            if (this.m_21224_()) {
                controller.setAnimation(this.DEATH_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.spawnTimer < 0) {
                if (this.m_5912_()) {
                    controller.setAnimation(this.ATTACK_ANIMATION);
                } else if (isMoving) {
                    controller.setAnimation(this.MOVE_ANIMATION);
                } else {
                    controller.setAnimation(this.IDLE_ANIMATION);
                }
                return PlayState.CONTINUE;
            }
            return PlayState.CONTINUE;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 0, event -> {
            if (this.getAnimation() == 0) {
                event.getController().setAnimation(this.SPAWN_ANIMATION);
                this.spawned = true;
                return PlayState.CONTINUE;
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    boolean isWithinDistance(BlockPos pos, int distance) {
        if (pos == null) {
            return false;
        }
        return pos.m_123314_((Vec3i)this.m_20183_(), (double)distance);
    }

    public void m_8032_() {
        this.m_5496_(TGSounds.WRAITH_AMBIENT.get(), 1.5f, -10.0f);
    }

    protected void m_6677_(DamageSource source) {
        this.m_5496_(TGSounds.WRAITH_HURT.get(), 1.0f, -10.0f);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.playDeathSound();
    }

    private void playDeathSound() {
        for (int i = 0; i < 10; ++i) {
            this.m_5496_(TGSounds.WRAITH_AMBIENT.get(), 2.5f, -10.0f);
        }
    }

    public boolean m_7337_(Entity other) {
        if (other instanceof WraithEntity) {
            return false;
        }
        return super.m_7337_(other);
    }

    protected void m_21229_() {
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    private static void triggerAdvancement(WraithEntity wraith, boolean bool) {
        Player player;
        if (bool && (player = wraith.m_20193_().m_45930_((Entity)wraith, 10.0)) instanceof ServerPlayer) {
            TGAdvancements.DIM_LIGHT.trigger((ServerPlayer)player);
        }
    }

    class WraithMeleeGoal
    extends MeleeAttackGoal {
        WraithMeleeGoal(PathfinderMob mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    private class ExtinguishGoal
    extends Goal {
        ExtinguishGoal() {
        }

        public boolean m_8036_() {
            if (WraithEntity.this.getTimeSinceExtinguish() >= 10) {
                return false;
            }
            return !(WraithEntity.this.f_19796_.m_188501_() < 0.3f);
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8037_() {
            if (WraithEntity.this.f_19796_.m_188503_(this.m_183277_(10)) == 0) {
                for (int i = 1; i <= 2; ++i) {
                    BlockPos blockPos = WraithEntity.this.m_20183_().m_6625_(i);
                    BlockState blockState = WraithEntity.this.m_20193_().m_8055_(blockPos);
                    Block block = blockState.m_60734_();
                    boolean bl = false;
                    boolean torchAndLantern = false;
                    if (blockState.m_204336_(BlockTags.f_144265_)) {
                        if (block instanceof CandleBlock) {
                            if (((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                                bl = true;
                            }
                        } else if (block instanceof BrazierBlock && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                            bl = true;
                        }
                        if (bl) {
                            WraithEntity.this.m_20193_().m_5594_((Player)null, blockPos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            WraithEntity.this.m_20193_().m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
                            WraithEntity.this.addExtinguishCounter();
                            WraithEntity.triggerAdvancement(WraithEntity.this, bl);
                            return;
                        }
                    }
                    if (WraithEntity.this.f_19796_.m_188503_(10) != 0) continue;
                    if (blockState.m_60713_(Blocks.f_50081_)) {
                        WraithEntity.this.m_20193_().m_46597_(blockPos, Blocks.f_50139_.m_49966_());
                        torchAndLantern = true;
                    } else if (blockState.m_60713_(Blocks.f_50681_)) {
                        WraithEntity.this.m_20193_().m_46597_(blockPos, (BlockState)((BlockState)Blocks.f_50682_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61435_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_))));
                        torchAndLantern = true;
                    } else if (blockState.m_60713_(Blocks.f_50082_)) {
                        WraithEntity.this.m_20193_().m_46597_(blockPos, (BlockState)Blocks.f_50140_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))));
                        torchAndLantern = true;
                    }
                    if (!torchAndLantern) continue;
                    WraithEntity.this.m_20193_().m_5594_((Player)null, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    WraithEntity.this.addExtinguishCounter();
                    return;
                }
            }
        }
    }

    class WraithWanderAroundGoal
    extends Goal {
        private static final int MAX_DISTANCE = 15;

        WraithWanderAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return WraithEntity.this.f_21344_.m_26571_() && WraithEntity.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return WraithEntity.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                WraithEntity.this.f_21344_.m_26536_(WraithEntity.this.f_21344_.m_7864_(BlockPos.m_274446_((Position)vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d2;
            if (!WraithEntity.this.isWithinDistance(WraithEntity.this.homePosition, 15) && WraithEntity.this.hasHomePosition()) {
                Vec3 vec3dx = Vec3.m_82512_((Vec3i)WraithEntity.this.homePosition);
                vec3d2 = vec3dx.m_82546_(WraithEntity.this.m_20182_()).m_82541_();
            } else {
                vec3d2 = WraithEntity.this.m_20252_(0.0f);
            }
            Vec3 vec3d3 = HoverRandomPos.m_148465_((PathfinderMob)WraithEntity.this, (int)8, (int)2, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (float)1.5707964f, (int)2, (int)1);
            return vec3d3 != null ? vec3d3 : AirAndWaterRandomPos.m_148357_((PathfinderMob)WraithEntity.this, (int)8, (int)2, (int)-2, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (double)1.5707963705062866);
        }
    }
}

