/*
 * Decompiled with CFR 0.152.
 */
package net.weaponleveling.util;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.weaponleveling.WLPlatformGetter;
import net.weaponleveling.WeaponLevelingConfig;
import net.weaponleveling.util.DataGetter;
import net.weaponleveling.util.ModUtils;
import net.weaponleveling.util.ToastHelper;
import org.jetbrains.annotations.Nullable;

public class UpdateLevels {
    public static void applyXPOnItemStack(ItemStack stack, Player player, Entity target, Boolean critical) {
        if (!player.m_9236_().f_46443_) {
            int xpamountcrit = 0;
            int xpamounthit = UpdateLevels.getXPForHit(stack);
            int xpamount = 0;
            if (critical.booleanValue()) {
                xpamountcrit = UpdateLevels.getXPForCrit(stack);
            }
            WLPlatformGetter.updateEpicFight(player, xpamount + xpamounthit + xpamountcrit);
            UpdateLevels.applyXPForArmor(player, xpamount + xpamounthit + xpamountcrit);
            UpdateLevels.updateProgressItem(player, stack, xpamount + xpamounthit + xpamountcrit);
        }
    }

    public static void applyXPForArmor(Player player, int value) {
        if (!(player.m_9236_().f_46443_ || player.m_6844_(EquipmentSlot.HEAD) == ItemStack.f_41583_ && player.m_6844_(EquipmentSlot.CHEST) == ItemStack.f_41583_ && player.m_6844_(EquipmentSlot.LEGS) == ItemStack.f_41583_ && player.m_6844_(EquipmentSlot.FEET) == ItemStack.f_41583_)) {
            ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
            ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
            ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
            ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
            if (ModUtils.isAcceptedArmor(helmet) && !ModUtils.isBroken(helmet)) {
                UpdateLevels.updateProgressItem(player, helmet, UpdateLevels.armorXPAmount(value, false, helmet));
            }
            if (ModUtils.isAcceptedArmor(chestplate) && !ModUtils.isBroken(chestplate)) {
                UpdateLevels.updateProgressItem(player, chestplate, UpdateLevels.armorXPAmount(value, false, chestplate));
            }
            if (ModUtils.isAcceptedArmor(leggings) && !ModUtils.isBroken(leggings)) {
                UpdateLevels.updateProgressItem(player, leggings, UpdateLevels.armorXPAmount(value, false, leggings));
            }
            if (ModUtils.isAcceptedArmor(feet) && !ModUtils.isBroken(feet)) {
                UpdateLevels.updateProgressItem(player, feet, UpdateLevels.armorXPAmount(value, false, feet));
            }
        }
    }

    public static void updateProgressItem(Player player, ItemStack stack, int updateamount) {
        int currentlevel = stack.m_41784_().m_128451_("level");
        int currentprogress = stack.m_41784_().m_128451_("levelprogress");
        currentprogress += updateamount;
        if (currentlevel < ModUtils.getMaxLevel(stack)) {
            UpdateLevels.updateItem(player, stack, currentlevel, currentprogress);
        }
    }

    private static void updateItem(Player player, ItemStack stack, int level, int progress) {
        int maxprogress = UpdateLevels.getMaxLevel(level, stack);
        if (progress >= maxprogress) {
            while (progress >= maxprogress) {
                progress -= maxprogress;
                maxprogress = UpdateLevels.getMaxLevel(++level, stack);
            }
            UpdateLevels.sendLevelUpNotification(player, stack, level);
        }
        stack.m_41784_().m_128405_("level", level);
        stack.m_41784_().m_128405_("levelprogress", progress);
    }

    public static int getMaxLevel(int currentlevel, ItemStack stack) {
        int levelmodifier = ModUtils.getLevelModifier(stack);
        int startinglevel = ModUtils.getLevelStartAmount(stack);
        int maxlevel = currentlevel != 0 ? startinglevel + (currentlevel - 1 + currentlevel) * levelmodifier : startinglevel;
        return maxlevel;
    }

    public static int getXPForEntity(Entity entity) {
        int xpamount = DataGetter.getXpGeneric();
        AtomicInteger liststate = new AtomicInteger();
        if (entity.m_6095_().m_204039_(DataGetter.entities_boss) || UpdateLevels.isCustomBoss(entity) || liststate.get() == 4) {
            xpamount = DataGetter.getXpBoss();
        } else if (entity.m_6095_().m_204039_(DataGetter.entities_mini_boss) || UpdateLevels.isCustomMiniBoss(entity) || liststate.get() == 3) {
            xpamount = DataGetter.getXpMiniboss();
        } else if (entity.m_6095_().m_204039_(DataGetter.entities_monster) || UpdateLevels.isCustomMonster(entity) || liststate.get() == 2) {
            xpamount = DataGetter.getXpMonster();
        } else if (entity.m_6095_().m_204039_(DataGetter.entities_animal) || UpdateLevels.isCustomAnimal(entity) || liststate.get() == 1) {
            xpamount = DataGetter.getXpAnimal();
        } else if (entity.m_6095_().m_204039_(DataGetter.entities_blacklist)) {
            xpamount = 0;
        }
        return xpamount;
    }

    private static boolean isCustomAnimal(Entity entity) {
        return entity.m_19880_().contains("wl_animal");
    }

    private static boolean isCustomMonster(Entity entity) {
        return entity.m_19880_().contains("wl_monster");
    }

    private static boolean isCustomMiniBoss(Entity entity) {
        return entity.m_19880_().contains("wl_miniboss");
    }

    private static boolean isCustomBoss(Entity entity) {
        return entity.m_19880_().contains("wl_boss");
    }

    public static int getXPForHit(ItemStack stack) {
        int xpamount = 0;
        int amount = ModUtils.getHitXPAmount(stack);
        if (UpdateLevels.shouldGiveHitXP(ModUtils.getHitXPChance(stack))) {
            xpamount = amount;
        }
        return xpamount;
    }

    public static int getXPForCrit(ItemStack stack) {
        int xpamount = 0;
        int amount = ModUtils.getCritXPAmount(stack);
        if (UpdateLevels.shouldGiveHitXP(ModUtils.getCritXPChance(stack))) {
            xpamount = amount;
        }
        return xpamount;
    }

    public static void sendLevelUpNotification(Player player, ItemStack stack, int level) {
        if (WeaponLevelingConfig.level_up_type == ToastHelper.LevelUpType.TOAST) {
            ToastHelper.sendToast((ServerPlayer)player, stack, level);
        } else {
            Style ITEM = Style.f_131099_.m_178520_(12517240);
            Style TEXT = Style.f_131099_.m_178520_(0x949292);
            Style VALUES = Style.f_131099_.m_178520_(15422034);
            String itemname = stack.m_41611_().getString();
            player.m_5661_((Component)Component.m_237113_((String)(itemname + " ")).m_6270_(ITEM).m_7220_((Component)Component.m_237115_((String)"weaponleveling.levelup").m_6270_(TEXT)).m_7220_((Component)Component.m_237113_((String)("" + level)).m_6270_(VALUES)), true);
        }
        Level world = player.m_9236_();
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.7f, 2.0f);
    }

    public static boolean shouldGiveHitXP(int probability) {
        double randomValue = Math.random() * 100.0;
        return randomValue <= (double)probability;
    }

    public static int armorXPAmount(int initialxp, boolean taxFree, ItemStack stack) {
        if (taxFree) {
            return initialxp;
        }
        double minamount = (double)ModUtils.getArmorXPRNGModifier(stack) / 100.0;
        double randomValue = minamount + (1.0 - minamount) * Math.random();
        if (randomValue < minamount) {
            randomValue = minamount;
        }
        return (int)((double)initialxp * randomValue);
    }

    public static void updateForKill(LivingEntity victim, DamageSource source, @Nullable ItemStack specificStack) {
        Entity killer = source.m_7639_();
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return;
        }
        if (source.m_276093_(DamageTypes.f_268515_)) {
            return;
        }
        if (killer instanceof Player) {
            Player player = (Player)killer;
            ItemStack stack = WLPlatformGetter.getAttackItem(player);
            ItemStack offhandStack = player.m_21206_();
            int xpamount = UpdateLevels.getXPForEntity((Entity)victim);
            if (specificStack != null) {
                UpdateLevels.updateProgressItem(player, specificStack, xpamount);
            } else if (source.m_269533_(DamageTypeTags.f_268524_)) {
                if (ModUtils.isAcceptedProjectileWeapon(stack)) {
                    UpdateLevels.updateProgressItem(player, stack, xpamount);
                } else if (ModUtils.isAcceptedProjectileWeapon(offhandStack)) {
                    UpdateLevels.updateProgressItem(player, offhandStack, xpamount);
                }
            } else if (ModUtils.isAcceptedMeleeWeaponStack(stack)) {
                UpdateLevels.updateProgressItem(player, stack, xpamount);
            }
            UpdateLevels.applyXPForArmor(player, xpamount);
            WLPlatformGetter.updateEpicFight(player, xpamount);
        }
    }

    public static void updateForHit(LivingEntity victim, DamageSource source, boolean crit, @Nullable ItemStack specificStack) {
        Entity killer = source.m_7639_();
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return;
        }
        if (source.m_276093_(DamageTypes.f_268515_)) {
            return;
        }
        if (killer instanceof Player) {
            Player player = (Player)killer;
            ItemStack stack = WLPlatformGetter.getAttackItem(player);
            if (specificStack != null) {
                UpdateLevels.applyXPOnItemStack(specificStack, player, (Entity)victim, crit);
            } else if (source.m_269533_(DamageTypeTags.f_268524_)) {
                ItemStack mainhand = player.m_21205_();
                ItemStack offhand = player.m_21206_();
                if (ModUtils.isAcceptedProjectileWeapon(mainhand)) {
                    UpdateLevels.applyXPOnItemStack(mainhand, player, (Entity)victim, crit);
                } else if (ModUtils.isAcceptedProjectileWeapon(offhand)) {
                    UpdateLevels.applyXPOnItemStack(offhand, player, (Entity)victim, crit);
                }
            } else if (ModUtils.isAcceptedMeleeWeaponStack(stack)) {
                UpdateLevels.applyXPOnItemStack(stack, player, (Entity)victim, crit);
            }
        }
    }
}

