/*
 * Decompiled with CFR 0.152.
 */
package net.weaponleveling.util;

import com.google.common.collect.Multimap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.weaponleveling.data.LevelableItem;
import net.weaponleveling.data.LevelableItemsLoader;
import net.weaponleveling.util.DataGetter;

public class ModUtils {
    public static void modifyAttributeModifier(Multimap<Attribute, AttributeModifier> multimap, Attribute attribute, double amount) {
        AttributeModifier modifier;
        if (multimap.get((Object)attribute).stream().findFirst().isPresent() && (modifier = (AttributeModifier)multimap.get((Object)attribute).stream().findFirst().get()).m_22218_() > 0.0) {
            AttributeModifier newmodifier = new AttributeModifier(modifier.m_22209_(), modifier.m_22214_(), modifier.m_22218_() + amount, modifier.m_22217_());
            multimap.remove((Object)attribute, (Object)modifier);
            multimap.put((Object)attribute, (Object)newmodifier);
        }
    }

    public static void removeAttributeModifier(Multimap<Attribute, AttributeModifier> multimap, Attribute attribute) {
        if (multimap.get((Object)attribute).stream().findFirst().isPresent()) {
            AttributeModifier modifier = (AttributeModifier)multimap.get((Object)attribute).stream().findFirst().get();
            AttributeModifier newmodifier = new AttributeModifier(modifier.m_22209_(), modifier.m_22214_(), 0.0, modifier.m_22217_());
            multimap.remove((Object)attribute, (Object)modifier);
            multimap.put((Object)attribute, (Object)newmodifier);
        }
    }

    public static boolean isLevelableJSON(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        return LevelableItemsLoader.isValid(stack.m_41720_()) && !levelableitem.isDisabled();
    }

    public static boolean isLevelableFallback(ItemStack stack) {
        return ModUtils.isFallbackMelee(stack) || ModUtils.isFallbackProjectile(stack) || ModUtils.isFallbackArmor(stack);
    }

    private static boolean isLevelableNBT(ItemStack stack) {
        boolean isMelee = false;
        boolean isProjectile = false;
        boolean isArmor = false;
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("isMelee")) {
            isMelee = stack.m_41783_().m_128469_("levelable").m_128471_("isMelee");
        }
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("isProjectile")) {
            isProjectile = stack.m_41783_().m_128469_("levelable").m_128471_("isProjectile");
        }
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("isArmor")) {
            isArmor = stack.m_41783_().m_128469_("levelable").m_128471_("isArmor");
        }
        return isMelee || isProjectile || isArmor;
    }

    public static boolean isLevelableItem(ItemStack stack) {
        return ModUtils.isLevelableJSON(stack) || ModUtils.isLevelableFallback(stack) || ModUtils.isLevelableNBT(stack);
    }

    private static boolean isFallbackMelee(ItemStack stack) {
        boolean isClassItem = (stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof AxeItem) && DataGetter.getDisableUnlisted() == false;
        return isClassItem || stack.m_204117_(DataGetter.melee_items);
    }

    private static boolean isFallbackProjectile(ItemStack stack) {
        boolean isClassItem = stack.m_41720_() instanceof ProjectileWeaponItem && DataGetter.getDisableUnlisted() == false;
        return isClassItem || stack.m_204117_(DataGetter.projectile_items);
    }

    private static boolean isFallbackArmor(ItemStack stack) {
        boolean isClassItem = stack.m_41720_() instanceof ArmorItem && DataGetter.getDisableUnlisted() == false;
        return isClassItem || stack.m_204117_(DataGetter.armor_items);
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("isBroken");
    }

    public static boolean shouldBeUnbreakable(ItemStack stack) {
        AtomicBoolean isInTag = new AtomicBoolean(false);
        if (DataGetter.getLevelableAutoUnbreakable().booleanValue() && ModUtils.isLevelableItem(stack) && !stack.m_204117_(DataGetter.non_vanish_items_blacklist)) {
            isInTag.set(true);
        }
        if (stack.m_204117_(DataGetter.non_vanish_items_whitelist) && !stack.m_204117_(DataGetter.non_vanish_items_blacklist)) {
            isInTag.set(true);
        }
        return isInTag.get();
    }

    public static boolean isAcceptedMeleeWeaponStack(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        boolean nbtadded = false;
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("isMelee")) {
            nbtadded = stack.m_41783_().m_128469_("levelable").m_128471_("isMelee");
        }
        return (ModUtils.isLevelableJSON(stack) && levelableitem.isMelee() || ModUtils.isFallbackMelee(stack) || nbtadded) && !ModUtils.isDisabled(stack);
    }

    public static boolean isAcceptedArmor(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        boolean nbtadded = false;
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("isArmor")) {
            nbtadded = stack.m_41783_().m_128469_("levelable").m_128471_("isArmor");
        }
        return (ModUtils.isLevelableJSON(stack) && levelableitem.isArmor() || ModUtils.isFallbackArmor(stack) || nbtadded) && !ModUtils.isDisabled(stack);
    }

    public static boolean isAcceptedProjectileWeapon(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        boolean nbtadded = false;
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("isProjectile")) {
            nbtadded = stack.m_41783_().m_128469_("levelable").m_128471_("isProjectile");
        }
        return (ModUtils.isLevelableJSON(stack) && levelableitem.isProjectile() || ModUtils.isFallbackProjectile(stack) || nbtadded) && !ModUtils.isDisabled(stack);
    }

    public static boolean isDisabled(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("disabled")) {
            return stack.m_41783_().m_128469_("levelable").m_128471_("disabled");
        }
        if (LevelableItemsLoader.isValid(stack.m_41720_())) {
            return levelableitem.isDisabled() || stack.m_204117_(DataGetter.blacklist_items);
        }
        return stack.m_204117_(DataGetter.blacklist_items);
    }

    public static int getMaxLevel(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("maxLevel")) {
            return stack.m_41783_().m_128469_("levelable").m_128451_("maxLevel");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getMaxLevel();
        }
        return DataGetter.getMaxLevel();
    }

    public static int getLevelModifier(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("levelModifier")) {
            return stack.m_41783_().m_128469_("levelable").m_128451_("levelModifier");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getLevelModifier();
        }
        return DataGetter.getLevelModifier();
    }

    public static int getLevelStartAmount(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("levelStartAmount")) {
            return stack.m_41783_().m_128469_("levelable").m_128451_("levelStartAmount");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getLevelStartAmount();
        }
        return DataGetter.getStartingXp();
    }

    public static int getHitXPAmount(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("hitXPAmount")) {
            return stack.m_41783_().m_128469_("levelable").m_128451_("hitXPAmount");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getHitXPAmount();
        }
        return DataGetter.getHitXpAmount();
    }

    public static int getHitXPChance(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("hitXPChance")) {
            return stack.m_41783_().m_128469_("levelable").m_128451_("hitXPChance");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getHitXPChance();
        }
        return DataGetter.getHitPercentage();
    }

    public static int getCritXPAmount(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("critXPAmount")) {
            return stack.m_41783_().m_128469_("levelable").m_128451_("critXPAmount");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getCritXPAmount();
        }
        return DataGetter.getCritXpAmount();
    }

    public static int getCritXPChance(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("critXPChance")) {
            return stack.m_41783_().m_128469_("levelable").m_128451_("critXPChance");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getCritXPChance();
        }
        return DataGetter.getCritPercentage();
    }

    public static double getWeaponDamagePerLevel(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("weaponDamagePerLevel")) {
            return stack.m_41783_().m_128469_("levelable").m_128459_("weaponDamagePerLevel");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getWeaponDamagePerLevel();
        }
        return DataGetter.getDamagePerLevel();
    }

    public static double getArmorPerLevel(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("armorPerLevel")) {
            return stack.m_41783_().m_128469_("levelable").m_128459_("armorPerLevel");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getArmorPerLevel();
        }
        return DataGetter.getArmorPerLevel();
    }

    public static double getToughnessPerLevel(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("toughnessPerLevel")) {
            return stack.m_41783_().m_128469_("levelable").m_128459_("toughnessPerLevel");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getToughnessPerLevel();
        }
        return DataGetter.getToughnessPerLevel();
    }

    public static double getBowlikeModifier(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("bowlikeModifier")) {
            return stack.m_41783_().m_128469_("levelable").m_128459_("bowlikeModifier");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getBowlikeModifier();
        }
        return DataGetter.getBowLikeModifier();
    }

    public static int getArmorXPRNGModifier(ItemStack stack) {
        LevelableItem levelableitem = LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (stack.m_41783_() != null && stack.m_41783_().m_128469_("levelable").m_128441_("armorXPRNGModifier")) {
            return stack.m_41783_().m_128469_("levelable").m_128451_("armorXPRNGModifier");
        }
        if (ModUtils.isLevelableJSON(stack)) {
            return levelableitem.getArmorXPRNGModifier();
        }
        return DataGetter.getArmorRng();
    }
}

