/*
 * Decompiled with CFR 0.152.
 */
package net.weaponleveling.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.weaponleveling.util.ModUtils;
import net.weaponleveling.util.UpdateLevels;

public class ItemLevelCommand {
    private static final DynamicCommandExceptionType NOT_VALID_ITEM = new DynamicCommandExceptionType(value -> Component.m_237110_((String)"weaponleveling.command.exception.novalidweapon", (Object[])new Object[]{value}));
    private static final DynamicCommandExceptionType OUT_OF_BOUNDS = new DynamicCommandExceptionType(value -> Component.m_237110_((String)"weaponleveling.command.exception.outofbounds", (Object[])new Object[]{value}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContex, Commands.CommandSelection commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"itemlevel").requires(permission -> permission.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82127_((String)"level").executes(command -> ItemLevelCommand.setLevelCommand((CommandSourceStack)command.getSource(), EntityArgument.m_91474_((CommandContext)command, (String)"player"), IntegerArgumentType.getInteger((CommandContext)command, (String)"value"), (CommandContext<CommandSourceStack>)command)))).then(Commands.m_82127_((String)"points").executes(command -> ItemLevelCommand.setPointCommand((CommandSourceStack)command.getSource(), EntityArgument.m_91474_((CommandContext)command, (String)"player"), IntegerArgumentType.getInteger((CommandContext)command, (String)"value"), (CommandContext<CommandSourceStack>)command)))))));
    }

    private static int setLevelCommand(CommandSourceStack source, ServerPlayer player, int level, CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ItemStack stack = player.m_21205_();
        if (ModUtils.isLevelableItem(stack)) {
            if (level > ModUtils.getMaxLevel(stack)) {
                throw OUT_OF_BOUNDS.create((Object)level);
            }
        } else {
            throw NOT_VALID_ITEM.create((Object)stack);
        }
        stack.m_41784_().m_128405_("level", level);
        source.m_288197_(() -> Component.m_237110_((String)"weaponleveling.command.setlevel", (Object[])new Object[]{stack.m_41786_(), level}), true);
        return 1;
    }

    private static int setPointCommand(CommandSourceStack source, ServerPlayer player, int points, CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ItemStack stack = player.m_21205_();
        int level = stack.m_41784_().m_128451_("levelprogress");
        int maxprogress = UpdateLevels.getMaxLevel(level, stack);
        if (ModUtils.isLevelableItem(stack)) {
            if (points > maxprogress) {
                throw OUT_OF_BOUNDS.create((Object)points);
            }
        } else {
            throw NOT_VALID_ITEM.create((Object)stack.m_41786_());
        }
        stack.m_41784_().m_128405_("levelprogress", points);
        source.m_288197_(() -> Component.m_237110_((String)"weaponleveling.command.setpoints", (Object[])new Object[]{stack.m_41786_(), points}), true);
        return 1;
    }
}

