/*
 * Decompiled with CFR 0.152.
 */
package net.weaponleveling.mixin;

import net.geradesolukas.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.weaponleveling.WLPlatformGetter;
import net.weaponleveling.util.ModUtils;
import net.weaponleveling.util.UpdateLevels;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Player.class})
public class MixinPlayer {
    @Inject(method={"die"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void injectedDie(DamageSource source, CallbackInfo ci) {
        LivingEntity victim = (LivingEntity)this;
        UpdateLevels.updateForKill(victim, source, null);
    }

    @Inject(method={"blockActionRestricted"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true)
    private void preventBlockTarget(Level level, BlockPos blockPos, GameType gameType, CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        if (ModUtils.isBroken(WLPlatformGetter.getAttackItem(player))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true)
    private void preventAttack(Entity target, CallbackInfo ci) {
        Player player = (Player)this;
        if (ModUtils.isBroken(WLPlatformGetter.getAttackItem(player))) {
            ci.cancel();
        }
    }

    @Inject(method={"interactOn"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true)
    private void preventInteract(Entity entity, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResult> cir) {
        Player player = (Player)this;
        if (ModUtils.isBroken(player.m_21205_())) {
            cir.setReturnValue((Object)InteractionResult.PASS);
        }
    }

    @ModifyExpressionValue(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;matches(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z")})
    private boolean preventCooldown(boolean original) {
        Player player = (Player)this;
        return original || ModUtils.isBroken(WLPlatformGetter.getAttackItem(player));
    }
}

