/*
 * Decompiled with CFR 0.152.
 */
package net.weaponleveling.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.weaponleveling.util.ModUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public abstract class MixinItemStack {
    @Shadow
    public abstract boolean m_220157_(int var1, RandomSource var2, @Nullable ServerPlayer var3);

    @Inject(method={"Lnet/minecraft/world/item/ItemStack;getAttributeModifiers(Lnet/minecraft/world/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectModifier(EquipmentSlot equipmentSlot, CallbackInfoReturnable<Multimap<Attribute, AttributeModifier>> cir) {
        HashMultimap hashmap = HashMultimap.create((Multimap)((Multimap)cir.getReturnValue()));
        ItemStack stack = (ItemStack)this;
        Attribute attackDamage = Attributes.f_22281_;
        Attribute attackSpeed = Attributes.f_22283_;
        Attribute armor = Attributes.f_22284_;
        Attribute armor_toughness = Attributes.f_22285_;
        if (ModUtils.isLevelableItem(stack) && ModUtils.isAcceptedMeleeWeaponStack(stack) && stack.m_41783_() != null) {
            ModUtils.modifyAttributeModifier((Multimap<Attribute, AttributeModifier>)hashmap, attackDamage, ModUtils.getWeaponDamagePerLevel(stack) * (double)stack.m_41783_().m_128451_("level"));
            ModUtils.modifyAttributeModifier((Multimap<Attribute, AttributeModifier>)hashmap, attackSpeed, 0.0);
        }
        if (ModUtils.isLevelableItem(stack) && ModUtils.isAcceptedArmor(stack) && stack.m_41783_() != null) {
            ModUtils.modifyAttributeModifier((Multimap<Attribute, AttributeModifier>)hashmap, armor, ModUtils.getArmorPerLevel(stack) * (double)stack.m_41783_().m_128451_("level"));
            ModUtils.modifyAttributeModifier((Multimap<Attribute, AttributeModifier>)hashmap, armor_toughness, ModUtils.getToughnessPerLevel(stack) * (double)stack.m_41783_().m_128451_("level"));
        }
        if (ModUtils.isBroken(stack)) {
            ModUtils.removeAttributeModifier((Multimap<Attribute, AttributeModifier>)hashmap, armor);
            ModUtils.removeAttributeModifier((Multimap<Attribute, AttributeModifier>)hashmap, armor_toughness);
        }
        cir.setReturnValue((Object)hashmap);
    }

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true)
    private void preventInteract(UseOnContext useOnContext, CallbackInfoReturnable<InteractionResult> cir) {
        if (ModUtils.isBroken(useOnContext.m_43722_())) {
            cir.setReturnValue((Object)InteractionResult.PASS);
        }
    }
}

