/*
 * Decompiled with CFR 0.152.
 */
package net.weaponleveling.forge.mixin;

import dev.architectury.platform.Platform;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.weaponleveling.util.DataGetter;
import net.weaponleveling.util.ModUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public class MixinItemStackForge {
    @Shadow
    public boolean m_220157_(int i, RandomSource randomSource, @Nullable ServerPlayer serverPlayer) {
        return false;
    }

    @Inject(method={"hurtAndBreak"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;", ordinal=1)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true)
    private <T extends LivingEntity> void preventBreak(int i, T livingEntity, Consumer<T> consumer, CallbackInfo ci) {
        ItemStack stack = (ItemStack)this;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (this.m_220157_(i, livingEntity.m_217043_(), player) && DataGetter.getBrokenItemsWontVanish() && ModUtils.shouldBeUnbreakable(stack)) {
                if (Platform.isForge()) {
                    // empty if block
                }
                CompoundTag tag = stack.m_41783_();
                tag.m_128379_("isBroken", true);
                stack.m_41751_(tag);
                ci.cancel();
            }
        }
    }
}

