/*
 * Decompiled with CFR 0.152.
 */
package net.weaponleveling.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.weaponleveling.WeaponLevelingConfig;
import net.weaponleveling.WeaponLevelingMod;
import net.weaponleveling.data.LevelableItem;
import org.apache.logging.log4j.util.Supplier;

public class LevelableItemsLoader
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String directory = "levelable_items";
    public static final LevelableItemsLoader INSTANCE = new LevelableItemsLoader();
    public static Map<ResourceLocation, JsonElement> MAP = new HashMap<ResourceLocation, JsonElement>();
    private static Map<ResourceLocation, LevelableItem> itemmap = ImmutableMap.of();

    public LevelableItemsLoader() {
        super(GSON, directory);
    }

    public void setMap(Map<ResourceLocation, LevelableItem> newmap) {
        itemmap = newmap;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        MAP = jsonMap;
    }

    public static void applyNew(Map<ResourceLocation, JsonElement> jsonMap) {
        ImmutableMap map;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        jsonMap.forEach((resourceLocation, jsonElement) -> {
            block12: {
                JsonObject jsonElementAsJsonObject = jsonElement.getAsJsonObject();
                if (jsonElementAsJsonObject.has("taglist") && jsonElementAsJsonObject.get("taglist").getAsBoolean()) {
                    try {
                        TagKey key;
                        JsonObject jsonObject = jsonElement.getAsJsonObject();
                        String keyString = resourceLocation.m_135815_();
                        if (WeaponLevelingConfig.send_registry_in_log) {
                            WeaponLevelingMod.LOGGER.info("Registering Tag: #" + resourceLocation);
                        }
                        if (BuiltInRegistries.f_257033_.m_203431_(key = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourceLocation)).isPresent()) {
                            if (WeaponLevelingConfig.send_registry_in_log) {
                                WeaponLevelingMod.LOGGER.info("Tagkey exists: #" + resourceLocation.toString());
                            }
                            ((HolderSet.Named)BuiltInRegistries.f_257033_.m_203431_(key).get()).forEach(itemHolder -> {
                                Item item = (Item)itemHolder.m_203334_();
                                if (WeaponLevelingConfig.send_registry_in_log) {
                                    WeaponLevelingMod.LOGGER.info("#" + resourceLocation + " contains " + BuiltInRegistries.f_257033_.m_7981_((Object)item));
                                }
                                LevelableItem levelableItem = LevelableItem.fromJson(jsonObject, BuiltInRegistries.f_257033_.m_7981_((Object)item));
                                builder.put((Object)BuiltInRegistries.f_257033_.m_7981_((Object)item), (Object)levelableItem);
                            });
                            break block12;
                        }
                        WeaponLevelingMod.LOGGER.error("{} is not a valid Item Tag", new Supplier[]{() -> resourceLocation});
                    }
                    catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                        WeaponLevelingMod.LOGGER.error("Parsing error loading Item Levels {}: {}", resourceLocation, (Object)jsonparseexception.getMessage());
                    }
                } else {
                    try {
                        JsonObject jsonObject = jsonElement.getAsJsonObject();
                        if (WeaponLevelingConfig.send_registry_in_log) {
                            WeaponLevelingMod.LOGGER.info("Registering: " + resourceLocation);
                        }
                        if (BuiltInRegistries.f_257033_.m_7804_(resourceLocation)) {
                            LevelableItem levelableItem = LevelableItem.fromJson(jsonObject, resourceLocation);
                            builder.put(resourceLocation, (Object)levelableItem);
                        } else {
                            WeaponLevelingMod.LOGGER.error("{} is not a valid Item", new Supplier[]{() -> resourceLocation});
                        }
                    }
                    catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                        WeaponLevelingMod.LOGGER.error("Parsing error loading Item Levels {}: {}", resourceLocation, (Object)jsonparseexception.getMessage());
                    }
                }
            }
        });
        itemmap = map = builder.build();
    }

    public static LevelableItem get(ResourceLocation resourceLocation) {
        return itemmap.get(resourceLocation);
    }

    public static boolean isValid(Item item) {
        return LevelableItemsLoader.get(BuiltInRegistries.f_257033_.m_7981_((Object)item)) != null;
    }
}

