/*
 * Decompiled with CFR 0.152.
 */
package net.weaponleveling.client;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.weaponleveling.WLPlatformGetter;
import net.weaponleveling.WeaponLevelingConfig;
import net.weaponleveling.util.ModUtils;
import net.weaponleveling.util.UpdateLevels;

public class ClientEvents {
    private static boolean shouldExtendTooltip() {
        boolean needshift = WeaponLevelingConfig.holdShiftToShow;
        if (needshift) {
            return Screen.m_96638_();
        }
        return true;
    }

    public static void onTooltipRender(ItemStack stack, List<Component> full_tooltip, TooltipFlag tooltipFlag) {
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        DecimalFormat doubleDecimalFormat = new DecimalFormat("#.##");
        DecimalFormat fourDecimalFormat = new DecimalFormat("#.####");
        Style TITLE = Style.f_131099_.m_178520_(WeaponLevelingConfig.titleColor);
        Style ARROW = Style.f_131099_.m_178520_(WeaponLevelingConfig.arrowColor);
        Style TEXT = Style.f_131099_.m_178520_(WeaponLevelingConfig.textColor);
        Style VALUES = Style.f_131099_.m_178520_(WeaponLevelingConfig.valuesColor);
        Style SHIFT = Style.f_131099_.m_178520_(WeaponLevelingConfig.shiftColor);
        Style BROKEN = Style.f_131099_.m_178520_(WeaponLevelingConfig.brokenColor);
        if (ModUtils.isBroken(stack)) {
            tooltip.add(Component.m_237115_((String)"weaponleveling.tooltip.broken").m_6270_(BROKEN));
        }
        if (ModUtils.isLevelableItem(stack)) {
            if (ClientEvents.shouldExtendTooltip()) {
                int level = stack.m_41784_().m_128451_("level");
                int levelprogress = stack.m_41784_().m_128451_("levelprogress");
                int maxlevelprogress = UpdateLevels.getMaxLevel(level, stack);
                tooltip.add(Component.m_237115_((String)"weaponleveling.tooltip.itemlevel").m_6270_(TITLE));
                tooltip.add(Component.m_237113_((String)" \u25b6 ").m_6270_(ARROW).m_7220_((Component)Component.m_237115_((String)"weaponleveling.tooltip.level").m_6270_(TEXT)).m_7220_((Component)Component.m_237113_((String)("" + level)).m_6270_(VALUES)));
                if (level < ModUtils.getMaxLevel(stack)) {
                    tooltip.add(Component.m_237113_((String)" \u25b6 ").m_6270_(ARROW).m_7220_((Component)Component.m_237115_((String)"weaponleveling.tooltip.levelprogress").m_6270_(TEXT)).m_7220_((Component)Component.m_237113_((String)("" + levelprogress)).m_6270_(VALUES)).m_7220_((Component)Component.m_237113_((String)"/").m_6270_(TEXT)).m_7220_((Component)Component.m_237113_((String)("" + maxlevelprogress)).m_6270_(VALUES)));
                } else if (level == ModUtils.getMaxLevel(stack)) {
                    tooltip.add(Component.m_237113_((String)" \u25b6 ").m_6270_(ARROW).m_7220_((Component)Component.m_237115_((String)"weaponleveling.tooltip.maxlevel").m_6270_(VALUES)));
                } else {
                    tooltip.add(Component.m_237113_((String)" \u25b6 ").m_6270_(ARROW).m_7220_((Component)Component.m_237115_((String)"weaponleveling.tooltip.overmaxlevel").m_6270_(VALUES)));
                }
                if (ModUtils.isAcceptedProjectileWeapon(stack) && !ModUtils.isAcceptedMeleeWeaponStack(stack) && !WLPlatformGetter.isCGMGunItem(stack)) {
                    double extradamage = (double)level * ModUtils.getWeaponDamagePerLevel(stack);
                    tooltip.add(Component.m_237113_((String)" \u25b6 ").m_6270_(ARROW).m_7220_((Component)Component.m_237115_((String)"weaponleveling.tooltip.projectile_weapon_level").m_6270_(TEXT)).m_7220_((Component)Component.m_237113_((String)doubleDecimalFormat.format(extradamage)).m_6270_(VALUES)));
                }
            } else {
                tooltip.add(Component.m_237115_((String)"weaponleveling.tooltip.pressshift").m_6270_(SHIFT));
            }
        }
        full_tooltip.addAll(1, tooltip);
    }
}

