/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.util;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.arrow.TrueDamageArrow;
import net.soulsweaponry.items.IDragonBonus;
import net.soulsweaponry.items.ILifeGuard;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.ModTags;

public class ModifyDamageUtil {
    public static float modifyDamageTakenTail(LivingEntity entity, float newAmount, DamageSource source) {
        Entity armorValue2;
        Player player;
        Entity entity2;
        if (entity.m_6095_().m_204039_(ModTags.Entities.DRAGONS) && (entity2 = source.m_7639_()) instanceof Player && (entity2 = (player = (Player)entity2).m_21205_().m_41720_()) instanceof IDragonBonus) {
            IDragonBonus dragonBonus = (IDragonBonus)entity2;
            newAmount += dragonBonus.getDragonBonus(player.m_21205_());
        }
        if (entity.m_21023_((MobEffect)EffectRegistry.DECAY.get()) && !entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.CHAOS_CROWN.get()) && !entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.CHAOS_HELMET.get())) {
            int amplifier = entity.m_21124_((MobEffect)EffectRegistry.DECAY.get()).m_19564_();
            float amountAdded = newAmount * ((float)(amplifier + 1) * 0.2f);
            newAmount += amountAdded;
        }
        if ((source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268530_)) && entity.m_21023_((MobEffect)EffectRegistry.MAGIC_RESISTANCE.get())) {
            int amplifier = entity.m_21124_((MobEffect)EffectRegistry.MAGIC_RESISTANCE.get()).m_19564_();
            float amountReduced = newAmount * ((float)(amplifier + 1) * 0.2f);
            newAmount -= amountReduced;
        }
        if (entity.m_21023_((MobEffect)EffectRegistry.POSTURE_BREAK.get()) && !source.m_269533_(DamageTypeTags.f_268524_)) {
            int amplifier = entity.m_21124_((MobEffect)EffectRegistry.POSTURE_BREAK.get()).m_19564_();
            float baseAdded = entity instanceof Player ? 3.0f : 8.0f;
            float totalAdded = baseAdded * (float)(amplifier + 1);
            newAmount += totalAdded;
            entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.CRIT_HIT_EVENT.get(), SoundSource.HOSTILE, 0.5f, 1.0f);
            entity.m_21195_((MobEffect)EffectRegistry.POSTURE_BREAK.get());
            if (entity.m_21023_(MobEffects.f_19597_) && entity.m_21124_(MobEffects.f_19597_).m_19557_() < 100) {
                entity.m_21195_(MobEffects.f_19597_);
            }
            if (entity.m_21023_(MobEffects.f_19613_) && entity.m_21124_(MobEffects.f_19613_).m_19557_() < 100) {
                entity.m_21195_(MobEffects.f_19613_);
            }
            if (entity.m_21023_(MobEffects.f_19599_) && entity.m_21124_(MobEffects.f_19599_).m_19557_() < 100) {
                entity.m_21195_(MobEffects.f_19599_);
            }
        }
        if (entity.m_21023_((MobEffect)EffectRegistry.BLIGHT.get()) && entity.m_21230_() > 0) {
            int amplifier = entity.m_21124_((MobEffect)EffectRegistry.BLIGHT.get()).m_19564_() + 1;
            int armorValue2 = entity.m_21230_();
            float increase = (float)((double)newAmount * (Math.log(amplifier) * (double)armorValue2 / 6.0 / 10.0));
            newAmount += increase;
        }
        if ((armorValue2 = source.m_7640_()) instanceof TrueDamageArrow) {
            TrueDamageArrow projectile = (TrueDamageArrow)armorValue2;
            float trueDamage = projectile.getTrueDamage();
            newAmount += entity instanceof Player ? trueDamage * ConfigConstructor.kraken_slayer_player_true_damage_taken_modifier : trueDamage;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = entity.m_21120_(hand);
            Item item = stack.m_41720_();
            if (!(item instanceof ILifeGuard)) continue;
            ILifeGuard guard = (ILifeGuard)item;
            float damage = Math.max(0.0f, (float)((double)newAmount * (1.0 - guard.getLifeGuardPercent(stack))));
            int rounded = Math.round(newAmount);
            newAmount = damage;
            int j = Math.min(rounded, 10);
            for (int i = 0; i < j; ++i) {
                ParticleHandler.singleParticle(entity.m_9236_(), (ParticleOptions)ParticleTypes.f_123746_, entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
            entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12404_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (entity.m_21223_() - newAmount < 0.0f && !entity.m_9236_().f_46443_ && guard.getLifeSaveChance(stack) < entity.m_217043_().m_188500_()) {
                ParticleHandler.particleSphereList(entity.m_9236_(), 500, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.4f, new ParticleOptions[]{ParticleTypes.f_235898_, ParticleTypes.f_123762_});
                entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
                for (Entity entity1 : entity.m_9236_().m_45933_((Entity)entity, entity.m_20191_().m_82400_(2.5))) {
                    if (!(entity1 instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity1;
                    living.m_6469_(entity.m_269291_().m_269036_((Entity)entity, (Entity)entity), guard.getLifeSaveExplosionDamage(stack));
                    double x = entity.m_20185_() - living.m_20185_();
                    double z = entity.m_20189_() - living.m_20189_();
                    living.m_147240_((double)guard.getLifeSaveExplosionKnockback(stack), x, z);
                }
                newAmount = 0.0f;
                rounded += guard.getLifeSaveStackDamage(stack);
            }
            if (rounded <= 0) break;
            stack.m_41622_(rounded, entity, p -> p.m_21190_(hand));
            break;
        }
        return newAmount;
    }
}

