/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.registry;

import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.soulsweaponry.entity.effect.BladeDance;
import net.soulsweaponry.entity.effect.ChungusTonic;
import net.soulsweaponry.entity.effect.Decay;
import net.soulsweaponry.entity.effect.Fear;
import net.soulsweaponry.entity.effect.Freezing;
import net.soulsweaponry.entity.effect.FrostMoon;
import net.soulsweaponry.entity.effect.HallowedDragonMist;
import net.soulsweaponry.entity.effect.LifeLeach;
import net.soulsweaponry.entity.effect.PostureBreak;
import net.soulsweaponry.entity.effect.VeilOfFire;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.ModTags;

public class EffectRegistry {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"soulsweapons");
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"soulsweapons");
    public static final RegistryObject<MobEffect> DECAY = EFFECTS.register("decay", Decay::new);
    public static final RegistryObject<MobEffect> FEAR = EFFECTS.register("fear", Fear::new);
    public static final RegistryObject<MobEffect> FREEZING = EFFECTS.register("freezing", Freezing::new);
    public static final RegistryObject<MobEffect> HALLOWED_DRAGON_MIST = EFFECTS.register("hallowed_dragon_mist", HallowedDragonMist::new);
    public static final RegistryObject<MobEffect> LIFE_LEACH = EFFECTS.register("life_leach", LifeLeach::new);
    public static final RegistryObject<MobEffect> POSTURE_BREAK = EFFECTS.register("posture_break", PostureBreak::new);
    public static final RegistryObject<MobEffect> RETRIBUTION = EFFECTS.register("retribution", () -> new DefaultStatusEffect(MobEffectCategory.HARMFUL, 13068032));
    public static final RegistryObject<MobEffect> VEIL_OF_FIRE = EFFECTS.register("veil_of_fire", VeilOfFire::new);
    public static final RegistryObject<MobEffect> BLOODTHIRSTY = EFFECTS.register("bloodthirsty", () -> new DefaultStatusEffect(MobEffectCategory.NEUTRAL, 6488329));
    public static final RegistryObject<MobEffect> MAGIC_RESISTANCE = EFFECTS.register("magic_resistance", () -> new DefaultStatusEffect(MobEffectCategory.BENEFICIAL, 0x80FFFF));
    public static final RegistryObject<MobEffect> MOON_HERALD = EFFECTS.register("moon_herald", () -> new DefaultStatusEffect(MobEffectCategory.BENEFICIAL, 256252));
    public static final RegistryObject<MobEffect> DISABLE_HEAL = EFFECTS.register("disable_heal", () -> new DefaultStatusEffect(MobEffectCategory.HARMFUL, 16555421));
    public static final RegistryObject<MobEffect> BLEED = EFFECTS.register("bleed", () -> new DefaultStatusEffect(MobEffectCategory.HARMFUL, 12192768));
    public static final RegistryObject<MobEffect> CALCULATED_FALL = EFFECTS.register("calculated_fall", () -> new DefaultStatusEffect(MobEffectCategory.BENEFICIAL, 0xFFFFFF));
    public static final RegistryObject<MobEffect> BLIGHT = EFFECTS.register("blight", () -> new DefaultStatusEffect(MobEffectCategory.HARMFUL, 7536956));
    public static final RegistryObject<MobEffect> SHADOW_STEP = EFFECTS.register("shadow_step", () -> new DefaultStatusEffect(MobEffectCategory.BENEFICIAL, 134776).m_19472_(Attributes.f_22279_, "48403ce1-d9b3-4757-b1ef-9fbacff0ed37", 0.3000000029802322, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<MobEffect> COOLDOWN = EFFECTS.register("cooldown", () -> new DefaultStatusEffect(MobEffectCategory.HARMFUL, 0x525252));
    public static final RegistryObject<MobEffect> GHOSTLY = EFFECTS.register("ghostly", () -> new DefaultStatusEffect(MobEffectCategory.BENEFICIAL, 6197649));
    public static final RegistryObject<MobEffect> CHUNGUS_TONIC_EFFECT = EFFECTS.register("chungus_tonic_effect", ChungusTonic::new);
    public static final RegistryObject<MobEffect> FROST_MOON = EFFECTS.register("frost_moon", FrostMoon::new);
    public static final RegistryObject<MobEffect> BLADE_DANCE = EFFECTS.register("blade_dance", BladeDance::new);
    public static final RegistryObject<Potion> WARDING = POTIONS.register("warding", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)MAGIC_RESISTANCE.get(), 4000, 0)}));
    public static final RegistryObject<Potion> STRONG_WARDING = POTIONS.register("strong_warding", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)MAGIC_RESISTANCE.get(), 2000, 1)}));
    public static final RegistryObject<Potion> LONG_WARDING = POTIONS.register("long_warding", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)MAGIC_RESISTANCE.get(), 8000, 0)}));
    public static final RegistryObject<Potion> TAINTED_AMBROSIA = POTIONS.register("tainted_ambrosia", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)DISABLE_HEAL.get(), 600, 0)}));
    public static final RegistryObject<Potion> CHUNGUS_TONIC_POTION = POTIONS.register("chungus_tonic", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, 1000, 2), new MobEffectInstance(MobEffects.f_19618_, 400, 1), new MobEffectInstance((MobEffect)CHUNGUS_TONIC_EFFECT.get(), 1000, 0)}));

    public static void registerEffects(IEventBus eventBus) {
        EFFECTS.register(eventBus);
    }

    public static void registerPotions(IEventBus eventBus) {
        POTIONS.register(eventBus);
    }

    static class DefaultStatusEffect
    extends MobEffect {
        public DefaultStatusEffect(MobEffectCategory pCategory, int pColor) {
            super(pCategory, pColor);
        }

        public boolean m_6584_(int duration, int amplifier) {
            if (this == BLEED.get()) {
                int i = 15 >> amplifier;
                if (i > 0) {
                    return duration % i == 0;
                }
                return true;
            }
            if (this == BLOODTHIRSTY.get()) {
                int k = 40 >> amplifier;
                if (k > 0) {
                    return duration % k == 0;
                }
                return true;
            }
            return false;
        }

        public void m_6742_(LivingEntity entity, int amplifier) {
            if (this == BLEED.get() && !entity.m_6095_().m_204039_(EntityTypeTags.f_13120_) && !entity.m_6095_().m_204039_(ModTags.Entities.SKELETONS)) {
                entity.m_6469_(CustomDamageSource.create(entity.m_9236_(), CustomDamageSource.BLEED), 1.0f + (float)amplifier);
            }
            if (this == BLOODTHIRSTY.get()) {
                entity.m_6469_(entity.m_9236_().m_269111_().m_269251_(), 1.0f);
            }
        }
    }
}

