/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.particles;

import java.util.ArrayList;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.soulsweaponry.registry.ParticleRegistry;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ChainLightningHandler {
    private static final float ARC_LENGTH = 1.0f;
    private static final float ARC_VARIATION = 1.5f;
    private static final float INACCURACY = 0.75f;
    private static final float MIN_SEGMENT_DIST = 3.0f;
    private static final float BRANCH_CHANCE = 2.0f;
    private static final int DENSITY = 8;

    public static void spawnChainLightning(ClientLevel world, Vector3f start0, Vector3f end0) {
        RandomSource rand = world.f_46441_;
        Vector3f start = new Vector3f((Vector3fc)start0);
        Vector3f end = new Vector3f((Vector3fc)end0);
        ArrayList<Vector3f> points = new ArrayList<Vector3f>();
        points.add(new Vector3f((Vector3fc)start));
        Vector3f last = new Vector3f((Vector3fc)start);
        while (last.distanceSquared((Vector3fc)end) > 9.0f) {
            Vector3f dir = new Vector3f((Vector3fc)end).sub((Vector3fc)last).normalize();
            Vector3f rnd = new Vector3f(rand.m_188501_() * 2.0f - 1.0f, rand.m_188501_() * 2.0f - 1.0f, rand.m_188501_() * 2.0f - 1.0f).mul(0.75f);
            dir.add((Vector3fc)rnd).normalize();
            float len = Mth.m_216267_((RandomSource)rand, (float)1.5f, (float)1.0f);
            Vector3f next = new Vector3f((Vector3fc)dir).mul(len).add((Vector3fc)last);
            points.add(next);
            last = next;
        }
        points.add(new Vector3f((Vector3fc)end));
        for (int i = 0; i < points.size() - 1; ++i) {
            Vector3f p1 = (Vector3f)points.get(i);
            Vector3f p2 = (Vector3f)points.get(i + 1);
            ChainLightningHandler.spawnParticlesOnLine(world, p1, p2);
            if (!(rand.m_188501_() < 2.0f)) continue;
            Vector3f branchDir = new Vector3f((Vector3fc)p2).sub((Vector3fc)p1).normalize();
            branchDir.add((Vector3fc)new Vector3f(rand.m_188501_() * 2.0f - 1.0f, rand.m_188501_() * 2.0f - 1.0f, rand.m_188501_() * 2.0f - 1.0f).mul(1.5f)).normalize();
            float branchLen = Mth.m_216267_((RandomSource)rand, (float)0.75f, (float)0.5f);
            Vector3f branchEnd = new Vector3f((Vector3fc)branchDir).mul(branchLen).add((Vector3fc)p1);
            ChainLightningHandler.spawnParticlesOnLine(world, p1, branchEnd);
        }
    }

    private static void spawnParticlesOnLine(ClientLevel world, Vector3f a, Vector3f b) {
        double dist = a.distance((Vector3fc)b);
        int steps = Mth.m_14165_((double)(dist * 8.0));
        for (int i = 0; i <= steps; ++i) {
            double t = (double)i / (double)steps;
            double x = Mth.m_14139_((double)t, (double)a.x, (double)b.x);
            double y = Mth.m_14139_((double)t, (double)a.y, (double)b.y);
            double z = Mth.m_14139_((double)t, (double)a.z, (double)b.z);
            world.m_7106_((ParticleOptions)ParticleRegistry.SOUL_SPARK.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

