/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.C2S;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.soulsweaponry.api.trickweapon.TrickWeaponUtil;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.SoundRegistry;

public class SwitchTrickWeaponC2S {
    public SwitchTrickWeaponC2S() {
    }

    public SwitchTrickWeaponC2S(FriendlyByteBuf buf) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            this.handlePacket(player, this);
        });
        context.setPacketHandled(true);
    }

    private void handlePacket(ServerPlayer player, SwitchTrickWeaponC2S packet) {
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        Item handItem = stack.m_41720_();
        ItemStack newWeapon = TrickWeaponUtil.getMappedStack(stack);
        if (newWeapon != null && !player.m_36335_().m_41519_(handItem)) {
            IConfigDisable disable;
            Item item = newWeapon.m_41720_();
            if (item instanceof IConfigDisable && (disable = (IConfigDisable)item).isDisabled(stack)) {
                disable.notifyDisabled((LivingEntity)player);
                return;
            }
            player.m_36335_().m_41524_(newWeapon.m_41720_(), 20);
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.TRICK_WEAPON_EVENT.get(), SoundSource.PLAYERS, 0.8f, Mth.m_216267_((RandomSource)player.m_217043_(), (float)0.75f, (float)1.5f));
            ParticleHandler.particleSphereList(player.m_9236_(), 20, player.m_20185_(), player.m_20186_(), player.m_20189_(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
            newWeapon.m_41721_(stack.m_41773_());
            int slot = player.m_150109_().f_35977_;
            player.m_150109_().m_8016_(slot);
            player.m_150109_().m_36040_(slot, newWeapon);
        }
    }
}

