/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class Skofnung
extends ModdedSword {
    public static final String EMPOWERED = "empowered_attacks_left";

    public Skofnung(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.skofnung_damage, ConfigConstructor.skofnung_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.DISABLE_HEAL, TooltipAbilities.SHARPEN, TooltipAbilities.IS_SHARPENED);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        int duration = ConfigConstructor.skofnung_disable_heal_duration + WeaponUtil.getEnchantDamageBonus(stack) * 40;
        target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.DISABLE_HEAL.get(), duration, 0));
        if (Skofnung.isEmpowered(stack)) {
            target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLEED.get(), 80, 0));
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                if (!player.m_36335_().m_41519_((Item)this)) {
                    this.reduceEmpowered(stack, player.m_9236_(), attacker);
                    player.m_36335_().m_41524_((Item)this, 5);
                }
            } else {
                this.reduceEmpowered(stack, attacker.m_9236_(), attacker);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND && Skofnung.isEmpowered(stack)) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(ConfigConstructor.skofnung_damage + (ConfigConstructor.skofnung_bonus_damage - 1)), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public static boolean isEmpowered(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(EMPOWERED) && stack.m_41783_().m_128451_(EMPOWERED) > 0 && !ConfigConstructor.disable_use_skofnung;
    }

    public static Integer empAttacksLeft(ItemStack stack) {
        if (Skofnung.isEmpowered(stack)) {
            return stack.m_41783_().m_128451_(EMPOWERED);
        }
        return 0;
    }

    private void reduceEmpowered(ItemStack stack, Level world, LivingEntity attacker) {
        if (Skofnung.isEmpowered(stack)) {
            stack.m_41783_().m_128405_(EMPOWERED, stack.m_41783_().m_128451_(EMPOWERED) - 1);
            if (stack.m_41783_().m_128451_(EMPOWERED) <= 0) {
                world.m_5594_(null, attacker.m_20183_(), SoundEvents.f_12644_, SoundSource.PLAYERS, 0.75f, 1.0f);
            }
        }
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_skofnung;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_skofnung;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }
}

