/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.items.sword.BluemoonShortsword;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.TooltipAbilities;

public class MoonlightShortsword
extends ModdedSword {
    public MoonlightShortsword(Tier toolMaterial, Item.Properties settings) {
        this(toolMaterial, ConfigConstructor.moonlight_shortsword_damage, ConfigConstructor.moonlight_shortsword_attack_speed, settings);
    }

    public MoonlightShortsword(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
        this.addTooltipAbility(TooltipAbilities.MOONLIGHT_ATTACK);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_moonlight_shortsword;
    }

    public static void summonSmallProjectile(Level world, Player user) {
        for (InteractionHand hand : InteractionHand.values()) {
            float f;
            ItemStack itemStack = user.m_21120_(hand);
            boolean effect = user.m_21023_((MobEffect)EffectRegistry.MOON_HERALD.get());
            boolean acceptItem = itemStack.m_41720_() instanceof MoonlightShortsword;
            if ((!acceptItem || user.m_36335_().m_41519_(itemStack.m_41720_())) && (!effect || user.m_36335_().m_41519_((Item)ItemRegistry.MOONSTONE_RING.get()))) continue;
            Item item = itemStack.m_41720_();
            if (item instanceof MoonlightShortsword) {
                MoonlightShortsword item2 = (MoonlightShortsword)item;
                f = item2.getProjectileDamage();
            } else {
                f = ConfigConstructor.moonlight_shortsword_projectile_damage;
            }
            float damage = f;
            MoonlightProjectile projectile = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOONLIGHT_ENTITY_TYPE.get()), world, (LivingEntity)user, itemStack);
            if (effect && !acceptItem) {
                damage += (float)user.m_21124_((MobEffect)EffectRegistry.MOON_HERALD.get()).m_19564_() * 2.0f;
                user.m_36335_().m_41524_((Item)ItemRegistry.MOONSTONE_RING.get(), 4);
            }
            projectile.setAgeAndPoints(15, 30, 1);
            projectile.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 1.5f, 0.0f);
            projectile.m_36781_(damage);
            world.m_7967_((Entity)projectile);
            Item item3 = itemStack.m_41720_();
            if (item3 instanceof BluemoonShortsword) {
                BluemoonShortsword bluemoon = (BluemoonShortsword)item3;
                bluemoon.applyItemCooldownNoCheck(user, Math.max(ConfigConstructor.bluemoon_shortsword_projectile_min_cooldown, ConfigConstructor.bluemoon_shortsword_projectile_cooldown - bluemoon.getReduceCooldownEnchantLevel(itemStack) * 10));
            }
            world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.MOONLIGHT_SMALL_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            user.m_36335_().m_41524_((Item)WeaponRegistry.MOONLIGHT_SHORTSWORD.get(), ConfigConstructor.moonlight_shortsword_projectile_cooldown);
            user.m_21011_(InteractionHand.MAIN_HAND, true);
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.isDisabled(stack)) {
            stack.m_41622_(1, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_moonlight_shortsword;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }

    public float getProjectileDamage() {
        return ConfigConstructor.moonlight_shortsword_projectile_damage;
    }
}

