/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.noclip.HolyMoonlightPillar;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.items.IChargeNeeded;
import net.soulsweaponry.items.IUndeadBonus;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;

public class HolyMoonlightGreatsword
extends ChargeToUseItem
implements IChargeNeeded,
IUndeadBonus {
    public HolyMoonlightGreatsword(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.holy_moonlight_greatsword_damage, ConfigConstructor.holy_moonlight_greatsword_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.NEED_CHARGE, TooltipAbilities.LUNAR_HERALD_NO_CHARGE, TooltipAbilities.CHARGE, TooltipAbilities.MOONFALL);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int chargeTime = this.getChargeTime(stack, remainingUseTicks);
            if (chargeTime >= 10) {
                int emp = player.m_21023_((MobEffect)EffectRegistry.MOON_HERALD.get()) ? 20 * player.m_21124_((MobEffect)EffectRegistry.MOON_HERALD.get()).m_19564_() : 0;
                this.applyItemCooldown(player, Math.max(ConfigConstructor.holy_moonlight_ability_min_cooldown, ConfigConstructor.holy_moonlight_ability_cooldown - this.getReduceCooldownEnchantLevel(stack) * 30 - emp));
                stack.m_41622_(5, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(player.m_7655_()));
                int ruptures = ConfigConstructor.holy_moonlight_ruptures_amount + WeaponUtil.getEnchantDamageBonus(stack);
                Vec3 vecBlocksAway = player.m_20154_().m_82490_(3.0).m_82549_(player.m_20182_());
                BlockPos targetArea = new BlockPos((int)vecBlocksAway.f_82479_, (int)user.m_20186_(), (int)vecBlocksAway.f_82481_);
                float power = ConfigConstructor.holy_moonlight_ability_damage;
                for (Entity entity : world.m_45933_((Entity)player, new AABB(targetArea).m_82400_(3.0))) {
                    if (!(entity instanceof LivingEntity)) continue;
                    entity.m_6469_(CustomDamageSource.create(world, CustomDamageSource.OBLITERATED, (Entity)player), power + 2.0f * EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)((LivingEntity)entity).m_6336_()));
                    entity.m_5997_(0.0, (double)this.getKnockup(stack), 0.0);
                }
                if (!world.f_46443_) {
                    WeaponUtil.doConsumerOnLine(world, user.m_146908_() + 90.0f, user.m_20182_(), 4.0, ruptures, 1.75f, (TriConsumer<Vec3, Integer, Float>)((TriConsumer)(position, warmup, yaw) -> {
                        HolyMoonlightPillar pillar = new HolyMoonlightPillar((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.HOLY_MOONLIGHT_PILLAR.get()), world);
                        pillar.m_5602_((Entity)user);
                        pillar.setParticleAmountMod(1.0f);
                        pillar.setRadius(1.85f);
                        pillar.m_36781_(this.getAbilityDamage());
                        pillar.setKnockUp(this.getKnockup(stack));
                        pillar.setWarmup((int)warmup);
                        pillar.m_20343_(position.m_7096_(), position.m_7098_(), position.m_7094_());
                        world.m_7967_((Entity)pillar);
                    }));
                }
                if (!player.m_7500_()) {
                    stack.m_41784_().m_128405_("current_charge", 0);
                }
                world.m_5594_(player, targetArea, (SoundEvent)SoundRegistry.MOONLIGHT_BIG_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                world.m_5594_(player, targetArea, SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!world.f_46443_) {
                    ParticleHandler.particleOutburstMap(player.m_9236_(), 150, vecBlocksAway.m_7096_(), user.m_20186_(), vecBlocksAway.m_7094_(), ParticleEvents.MOONFALL_MAP, 1.0f);
                }
            }
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.isDisabled(stack)) {
            this.addCharge(stack, this.getAddedCharge(stack));
        }
        return super.m_7579_(stack, target, attacker);
    }

    private float getAbilityDamage() {
        return ConfigConstructor.holy_moonlight_ability_damage;
    }

    private float getKnockup(ItemStack stack) {
        return ConfigConstructor.holy_moonlight_ability_knockup + (float)WeaponUtil.getEnchantDamageBonus(stack) / 10.0f;
    }

    @Override
    public int getMaxCharge() {
        return ConfigConstructor.holy_moonlight_ability_charge_needed;
    }

    @Override
    public int getAddedCharge(ItemStack stack) {
        int base = ConfigConstructor.holy_moonlight_greatsword_charge_added_post_hit;
        return base + WeaponUtil.getEnchantDamageBonus(stack) * 2;
    }

    @Override
    public boolean acceptsMoonHeraldEffect(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.holy_moonlight_ability_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.holy_moonlight_ability_enchant_reduces_cooldown_ids;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_holy_moonlight_greatsword;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_holy_moonlight_greatsword;
    }

    @Override
    public boolean isRighteous() {
        return true;
    }

    @Override
    public float getUndeadBonus(ItemStack stack) {
        return ConfigConstructor.holy_moonlight_greatsword_righteous_undead_bonus_damage;
    }
}

