/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.FrostGiant;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entity.mobs.RimeSpectre;
import net.soulsweaponry.entitydata.SummonsData;
import net.soulsweaponry.items.ISummonAllies;
import net.soulsweaponry.items.SoulHarvestingItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class Frostmourne
extends SoulHarvestingItem
implements ISummonAllies {
    public Frostmourne(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.frostmourne_damage, ConfigConstructor.frostmourne_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.SOUL_RELEASE, TooltipAbilities.FREEZE, TooltipAbilities.PERMAFROST);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        int amp = Mth.m_14167_((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f));
        target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZING.get(), 160, amp));
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (this.isDisabled(stack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (this.getSouls(stack) >= 5 && !world.f_46443_ && this.canSummonEntity((ServerLevel)world, (LivingEntity)user, this.getSummonsListId())) {
            Vec3 vecBlocksAway = user.m_20154_().m_82490_(3.0).m_82549_(user.m_20182_());
            BlockPos on = BlockPos.m_274446_((Position)vecBlocksAway);
            Remnant entity = user.m_217043_().m_188499_() ? new FrostGiant((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.FROST_GIANT.get()), world) : new RimeSpectre((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.RIME_SPECTRE.get()), world);
            entity.m_20343_(vecBlocksAway.f_82479_, user.m_20186_() + (double)0.1f, vecBlocksAway.f_82481_);
            entity.m_21828_(user);
            if (entity instanceof RimeSpectre) {
                entity.m_5997_(0.0, 0.1f, 0.0);
            }
            entity.m_7105_(true);
            world.m_7967_((Entity)entity);
            this.saveSummonUuid((LivingEntity)user, entity.m_20148_());
            this.addAmount(stack, -5);
            world.m_5594_(null, on, (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.PLAYERS, 0.75f, 1.0f);
            ParticleHandler.particleOutburstMap(world, 50, vecBlocksAway.m_7096_(), vecBlocksAway.m_7098_(), vecBlocksAway.m_7094_(), ParticleEvents.SOUL_RUPTURE_MAP, 1.0f);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)true);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @Override
    public int getMaxSummons() {
        return ConfigConstructor.frostmourne_summoned_allies_cap;
    }

    @Override
    public String getSummonsListId() {
        return "FrostmourneSummons";
    }

    @Override
    public void saveSummonUuid(LivingEntity user, UUID summonUuid) {
        SummonsData.addSummonUUID(user, summonUuid, this.getSummonsListId());
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_frostmourne;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_frostmourne;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }
}

