/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.items.ILifeGuard;
import net.soulsweaponry.util.TooltipAbilities;

public class Excalibur
extends ChargeToUseItem
implements ILifeGuard {
    public Excalibur(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.excalibur_damage, ConfigConstructor.excalibur_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.SONIC_BOOM, TooltipAbilities.LIFE_GUARD);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        int time;
        Player player;
        if (user instanceof Player && !(player = (Player)user).m_36335_().m_41519_((Item)this) && !world.f_46443_ && (time = this.getChargeTime(stack, remainingUseTicks)) >= 10) {
            LivingEntity target;
            Predicate<LivingEntity> nonTeammate = entity -> !entity.m_7307_((Entity)user) && !(entity instanceof ArmorStand);
            TargetingConditions targetPredicate = TargetingConditions.m_148353_().m_26883_((double)ConfigConstructor.excalibur_sonic_boom_target_search_range).m_148355_().m_26888_(nonTeammate);
            if (user.m_21214_() != null) {
                target = user.m_21214_();
                if (user.m_20270_((Entity)target) > ConfigConstructor.excalibur_sonic_boom_max_range) {
                    target = world.m_45963_(LivingEntity.class, targetPredicate, user, user.m_20185_(), user.m_20186_(), user.m_20189_(), user.m_20191_().m_82400_(16.0));
                }
            } else {
                target = world.m_45963_(LivingEntity.class, targetPredicate, user, user.m_20185_(), user.m_20186_(), user.m_20189_(), user.m_20191_().m_82400_(16.0));
            }
            if (target != null) {
                boolean withinRange;
                boolean bl = withinRange = user.m_20270_((Entity)target) <= ConfigConstructor.excalibur_sonic_boom_max_range;
                if (!withinRange) {
                    world.m_5594_(null, user.m_20183_(), SoundEvents.f_12404_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (ConfigConstructor.inform_player_about_out_of_range) {
                        player.m_5661_((Component)Component.m_237115_((String)"soulsweapons.weapon.out_of_range"), true);
                    }
                    return;
                }
                world.m_7605_((Entity)user, (byte)62);
                Vec3 vec3d = user.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
                Vec3 vec3d2 = target.m_146892_().m_82546_(vec3d);
                Vec3 vec3d3 = vec3d2.m_82541_();
                for (int i = 1; i < Mth.m_14107_((double)vec3d2.m_82553_()) + 7; ++i) {
                    Vec3 vec3d4 = vec3d.m_82549_(vec3d3.m_82490_((double)i));
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_235902_, vec3d4.f_82479_, vec3d4.f_82480_, vec3d4.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
                world.m_5594_(null, user.m_20183_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 3.0f, 1.0f);
                target.m_6469_(world.m_269111_().m_269285_((Entity)user), ConfigConstructor.excalibur_sonic_boom_damage + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)target.m_6336_()));
                user.m_21335_((Entity)target);
                double d = 0.5 * (1.0 - target.m_21133_(Attributes.f_22278_));
                double e = 2.5 * (1.0 - target.m_21133_(Attributes.f_22278_));
                Vec3 vec = new Vec3(vec3d3.m_7096_() * e, vec3d3.m_7098_() * d, vec3d3.m_7094_() * e).m_82490_((double)ConfigConstructor.excalibur_sonic_boom_knockback_power);
                target.m_246865_(vec);
                stack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                this.applyItemCooldown(player, Math.max(ConfigConstructor.excalibur_sonic_boom_min_cooldown, ConfigConstructor.excalibur_sonic_boom_cooldown - this.getReduceCooldownEnchantLevel(stack) * 8));
            } else {
                world.m_5594_(null, user.m_20183_(), SoundEvents.f_12404_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (ConfigConstructor.inform_player_about_out_of_range) {
                    player.m_5661_((Component)Component.m_237115_((String)"soulsweapons.weapon.out_of_range"), true);
                }
            }
        }
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_excalibur;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_excalibur;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.excalibur_enchant_reduces_ability_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.excalibur_enchant_reduces_ability_cooldown_ids;
    }

    @Override
    public double getLifeGuardPercent(ItemStack stack) {
        return ConfigConstructor.excalibur_life_guard_percent;
    }

    @Override
    public double getLifeSaveChance(ItemStack stack) {
        return ConfigConstructor.excalibur_life_save_chance_percent;
    }

    @Override
    public float getLifeSaveExplosionDamage(ItemStack stack) {
        return ConfigConstructor.excalibur_life_save_explosion_damage;
    }

    @Override
    public float getLifeSaveExplosionKnockback(ItemStack stack) {
        return ConfigConstructor.excalibur_life_save_explosion_knockback;
    }

    @Override
    public int getLifeSaveStackDamage(ItemStack stack) {
        return ConfigConstructor.excalibur_life_save_stack_damage;
    }
}

