/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class DarkMoonGreatsword
extends ChargeToUseItem
implements IKeybindAbility {
    public DarkMoonGreatsword(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.dark_moon_greatsword_damage, ConfigConstructor.dark_moon_greatsword_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.FREEZE, TooltipAbilities.PERMAFROST, TooltipAbilities.FROST_MOON);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.isDisabled(stack)) {
            target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FREEZING.get(), ConfigConstructor.dark_moon_greatsword_post_hit_permafrost_base_duration, ConfigConstructor.dark_moon_greatsword_post_hit_permafrost_base_amplifier + WeaponUtil.getEnchantDamageBonus(stack)));
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            int i = this.getChargeTime(stack, remainingUseTicks);
            if (i >= 10) {
                stack.m_41622_(1, (LivingEntity)playerEntity, p -> p.m_21190_(user.m_7655_()));
                int duration = ConfigConstructor.dark_moon_greatsword_projectile_permafrost_base_duration;
                int amp = ConfigConstructor.dark_moon_greatsword_projectile_permafrost_base_amplifier + WeaponUtil.getEnchantDamageBonus(stack);
                MoonlightProjectile entity = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.DARK_MOON_PROJECTILE.get()), world, user, stack);
                entity.setAppliedStatusEffect((MobEffect)EffectRegistry.FREEZING.get());
                entity.setEffectAmplifier(amp);
                entity.setAppliedEffectTicks(duration);
                entity.setAgeAndPoints(30, 150, 4);
                entity.setAreaParticleCount(8);
                entity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 1.5f, 1.0f);
                entity.m_36781_(ConfigConstructor.dark_moon_greatsword_projectile_damage);
                world.m_7967_((Entity)entity);
                world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.MOONLIGHT_BIG_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_21023_((MobEffect)EffectRegistry.FROST_MOON.get()) && !user.m_7500_()) {
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_dark_moon_greatsword;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_dark_moon_greatsword;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.dark_moon_greatsword_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.dark_moon_greatsword_enchant_reduces_cooldown_ids;
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        if (this.isDisabled(stack) || player.m_21023_((MobEffect)EffectRegistry.COOLDOWN.get()) && !player.m_7500_()) {
            return;
        }
        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        int duration = ConfigConstructor.dark_moon_greatsword_frost_moon_base_duration;
        int amp = ConfigConstructor.dark_moon_greatsword_frost_moon_base_amplifier;
        int cooldown = ConfigConstructor.dark_moon_greatsword_frost_moon_cooldown;
        cooldown = Math.max(ConfigConstructor.dark_moon_greatsword_frost_moon_min_cooldown, cooldown - this.getReduceCooldownEnchantLevel(stack) * 60);
        this.applyEffectCooldown(player, cooldown);
        player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FROST_MOON.get(), duration, amp));
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_144211_, player.m_5720_(), 1.0f, 1.0f);
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, LocalPlayer player) {
    }
}

