/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.util.TooltipAbilities;

public class CrucibleSword
extends ModdedSword {
    private static final String EMP = "empowered";

    public CrucibleSword(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.crucible_sword_normal_damage, ConfigConstructor.crucible_sword_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.DOOM);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (!this.isDisabled(stack) && !player.m_36335_().m_41519_((Item)this)) {
                Level world = player.m_9236_();
                float cooldownMod = !world.f_46443_ && world.m_220362_() == BuiltinDimensionTypes.f_223539_ ? ConfigConstructor.crucible_sword_empowered_cooldown_modifier_in_nether : 1.0f;
                this.applyItemCooldown(player, (int)((float)Math.max(ConfigConstructor.crucible_sword_empowered_min_cooldown, ConfigConstructor.crucible_sword_empowered_cooldown - this.getReduceCooldownEnchantLevel(stack) * 20) * cooldownMod));
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.updateEmpowered(stack, !player.m_36335_().m_41519_((Item)this));
        }
    }

    private void updateEmpowered(ItemStack stack, boolean bl) {
        stack.m_41784_().m_128379_(EMP, bl);
    }

    private boolean isEmpowered(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(EMP)) {
            return stack.m_41783_().m_128471_(EMP);
        }
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)((this.isEmpowered(stack) && !this.isDisabled(stack) ? ConfigConstructor.crucible_sword_empowered_damage : ConfigConstructor.crucible_sword_normal_damage) - 1), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_crucible_sword;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_crucible_sword;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.crucible_sword_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.crucible_sword_enchant_reduces_cooldown_ids;
    }
}

