/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.BloodthirsterRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Bloodthirster
extends ModdedSword
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Bloodthirster(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.bloodthirster_damage, ConfigConstructor.bloodthirster_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.LIFE_STEAL, TooltipAbilities.OVERHEAL);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_bloodthirster;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        if (attacker instanceof Player && !(player = (Player)attacker).m_36335_().m_41519_(stack.m_41720_())) {
            this.applyItemCooldown(player, Math.max(ConfigConstructor.lifesteal_item_min_cooldown, ConfigConstructor.lifesteal_item_cooldown - this.getReduceLifeStealCooldownEnchantLevel(stack) * 6));
            float healing = ConfigConstructor.lifesteal_item_base_healing;
            if (ConfigConstructor.lifesteal_item_heal_scales) {
                healing += (float)Mth.m_14167_((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f));
            }
            if (player.m_21223_() == player.m_21233_() && ConfigConstructor.bloodthirster_overshields) {
                healing = healing - 4.0f > 0.0f ? healing - 4.0f : 0.0f;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 60 + Mth.m_14143_((float)(healing * 10.0f)), Mth.m_14143_((float)healing)));
            } else if (player.m_21223_() < player.m_21233_()) {
                attacker.m_5634_(healing);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BloodthirsterRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new BloodthirsterRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_bloodthirster;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.lifesteal_item_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.lifesteal_item_enchant_reduces_cooldown_ids;
    }
}

