/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.staff;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.DragonStaffProjectile;
import net.soulsweaponry.entity.projectile.GrowingFireball;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.util.LuckChosenObject;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public class WitheredWabbajack
extends ModdedSword {
    private static final List<LuckChosenObject<EntityType<?>>> PROJECTILES = new ArrayList();

    public WitheredWabbajack(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.withered_wabbajack_damage, ConfigConstructor.withered_wabbajack_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.WABBAJACK, TooltipAbilities.LUCK_BASED);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (this.isDisabled(itemStack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_36335_().m_41524_((Item)this, 1);
        world.m_6263_(user, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11896_, SoundSource.NEUTRAL, 0.5f, 2.0f / (world.m_213780_().m_188501_() * 0.4f + 0.8f));
        if (!world.f_46443_) {
            EntityType<?> type = this.calculateProjectile((LivingEntity)user);
            Entity entity = type.m_20615_(world);
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                projectile.m_5602_((Entity)user);
                if (entity instanceof DragonStaffProjectile) {
                    DragonStaffProjectile dragonStaffProjectile = (DragonStaffProjectile)entity;
                    dragonStaffProjectile.setRadius(2.0f + user.m_217043_().m_188501_() * (float)WeaponUtil.getLuckFactor((LivingEntity)user));
                }
                projectile.m_20343_(user.m_20185_(), user.m_20188_(), user.m_20189_());
                if (entity instanceof GrowingFireball) {
                    GrowingFireball ball = (GrowingFireball)entity;
                    float power = 1.0f + user.m_217043_().m_188501_() * 10.0f * (float)WeaponUtil.getLuckFactor((LivingEntity)user);
                    int duration = user.m_217043_().m_216332_(10, 100 + 20 * WeaponUtil.getLuckFactor((LivingEntity)user));
                    float speed = (float)user.m_217043_().m_216332_(25, 300 + 20 * WeaponUtil.getLuckFactor((LivingEntity)user)) / 100.0f;
                    ball.setMaxAge(duration);
                    ball.setRadiusGrowth(power / (float)duration);
                    ball.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, speed, 0.0f);
                } else {
                    projectile.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 1.5f, 0.0f);
                }
                world.m_7967_(entity);
                itemStack.m_41622_(1, (LivingEntity)user, p_220045_0_ -> p_220045_0_.m_21190_(hand));
            }
            for (LuckChosenObject<EntityType<?>> luckChosenEntity : PROJECTILES) {
                luckChosenEntity.setLuckFactor(10);
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.m_5776_());
    }

    public static void initProjectileList() {
        PROJECTILES.add(new LuckChosenObject<EntityType>(EntityType.f_20548_, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<EntityType>(EntityType.f_20483_, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<EntityType>(EntityType.f_20484_, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<EntityType>(EntityType.f_20485_, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<EntityType>(EntityType.f_20527_, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<EntityType>(EntityType.f_20477_, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<EntityType>(EntityType.f_20498_, WeaponUtil.LuckType.BAD));
        PROJECTILES.add(new LuckChosenObject<EntityType>(EntityType.f_20463_, WeaponUtil.LuckType.NEUTRAL));
        PROJECTILES.add(new LuckChosenObject<EntityType>((EntityType)EntityRegistry.GROWING_FIREBALL_ENTITY.get(), WeaponUtil.LuckType.NEUTRAL));
        PROJECTILES.add(new LuckChosenObject<EntityType>((EntityType)EntityRegistry.DRAGON_STAFF_PROJECTILE.get(), WeaponUtil.LuckType.NEUTRAL));
        PROJECTILES.add(new LuckChosenObject<EntityType>((EntityType)EntityRegistry.WITHERED_WABBAJACK_PROJECTILE.get(), WeaponUtil.LuckType.GOOD));
    }

    private EntityType<?> calculateProjectile(LivingEntity user) {
        ArrayList projectileList = new ArrayList();
        for (LuckChosenObject<EntityType<?>> luckChosenObject : PROJECTILES) {
            switch (luckChosenObject.getLuckType()) {
                case BAD: {
                    luckChosenObject.setLuckFactor(luckChosenObject.getLuckFactor() - WeaponUtil.getLuckFactor(user));
                    break;
                }
                case GOOD: {
                    luckChosenObject.setLuckFactor(luckChosenObject.getLuckFactor() + WeaponUtil.getLuckFactor(user));
                }
            }
            if (luckChosenObject.getLuckFactor() <= 0) continue;
            projectileList.add(luckChosenObject);
        }
        int totalChance = 0;
        for (LuckChosenObject luckChosenObject : projectileList) {
            totalChance += luckChosenObject.getLuckFactor();
        }
        int n = user.m_217043_().m_188503_(totalChance);
        EntityType<?> entityType = this.getEntityType(projectileList, n);
        if (entityType != null) {
            return entityType;
        }
        return EntityType.f_20548_;
    }

    @Nullable
    private EntityType<?> getEntityType(List<LuckChosenObject<EntityType<?>>> projectileList, int random) {
        int cumulativeFactor = 0;
        for (LuckChosenObject<EntityType<?>> luckChosen : projectileList) {
            if (random >= (cumulativeFactor += luckChosen.getLuckFactor())) continue;
            return luckChosen.getObject();
        }
        return null;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_withered_wabbajack;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_withered_wabbajack;
    }
}

