/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.spear;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.DraupnirSpearItemRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.DraupnirSpearEntity;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DraupnirSpear
extends ChargeToUseItem
implements GeoItem,
IKeybindAbility {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String SPEARS_ID = "thrown_spears_id";

    public DraupnirSpear(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.draupnir_spear_damage, ConfigConstructor.draupnir_spear_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.INFINITY, TooltipAbilities.DETONATE_SPEARS);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        int i;
        Player playerEntity;
        if (user instanceof Player && !(playerEntity = (Player)user).m_36335_().m_41519_((Item)this) && (i = this.getChargeTime(stack, remainingUseTicks)) >= 10) {
            DraupnirSpearEntity entity = new DraupnirSpearEntity(world, (LivingEntity)playerEntity, stack);
            entity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 5.0f, 1.0f);
            entity.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            world.m_7967_((Entity)entity);
            world.m_6269_(null, (Entity)entity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.saveSpearData(stack, entity);
            this.applyItemCooldown(playerEntity, this.getScaledCooldownThrow(stack));
            stack.m_41622_(1, (LivingEntity)playerEntity, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
        }
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.draupnir_spear_enchant_reduces_throw_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.draupnir_spear_enchant_reduces_throw_cooldown_ids;
    }

    protected int getReduceCooldownEnchantLevelAbility(ItemStack stack) {
        if (ConfigConstructor.draupnir_spear_enchant_reduces_ability_cooldown) {
            return this.getMaxLevel(ConfigConstructor.draupnir_spear_enchant_reduces_ability_cooldown_ids, stack);
        }
        return 0;
    }

    protected int getScaledCooldownThrow(ItemStack stack) {
        int base = ConfigConstructor.draupnir_spear_throw_cooldown;
        return Math.max(ConfigConstructor.draupnir_spear_throw_min_cooldown, base - this.getReduceCooldownEnchantLevel(stack) * 5);
    }

    protected int getScaledCooldownSummon(ItemStack stack) {
        int base = ConfigConstructor.draupnir_spear_summon_spears_cooldown;
        return Math.max(ConfigConstructor.draupnir_spear_summon_spears_min_cooldown, base - this.getReduceCooldownEnchantLevelAbility(stack) * 20);
    }

    protected int getScaledCooldownExplode(ItemStack stack) {
        int base = ConfigConstructor.draupnir_spear_detonate_cooldown;
        return Math.max(ConfigConstructor.draupnir_spear_detonate_min_cooldown, base - this.getReduceCooldownEnchantLevelAbility(stack) * 7);
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private DraupnirSpearItemRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new DraupnirSpearItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_draupnir_spear;
    }

    private void saveSpearData(ItemStack stack, DraupnirSpearEntity entity) {
        if (stack.m_41784_() != null) {
            List<Integer> ids = new ArrayList<Integer>();
            if (stack.m_41783_().m_128441_(SPEARS_ID)) {
                int[] arr = stack.m_41783_().m_128465_(SPEARS_ID);
                ids = WeaponUtil.arrayToList(arr);
            }
            ids.add(entity.m_19879_());
            stack.m_41783_().m_128408_(SPEARS_ID, ids);
        }
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        if (!player.m_36335_().m_41519_(stack.m_41720_())) {
            if (player.m_6144_()) {
                if (!player.m_21023_((MobEffect)EffectRegistry.COOLDOWN.get())) {
                    int r = 4;
                    world.m_5594_(null, player.m_20183_(), SoundEvents.f_11880_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    for (int theta = 0; theta < 360; theta += 45) {
                        double x0 = player.m_20185_();
                        double z0 = player.m_20189_();
                        double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
                        double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
                        double x1 = Math.cos((double)theta * Math.PI / 180.0);
                        double z1 = Math.sin((double)theta * Math.PI / 180.0);
                        DraupnirSpearEntity entity = new DraupnirSpearEntity((Level)world, (LivingEntity)player, stack);
                        entity.m_20343_(x, player.m_20186_() + 5.0, z);
                        entity.m_20334_(x1, -3.0, z1);
                        entity.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                        world.m_7967_((Entity)entity);
                        this.saveSpearData(stack, entity);
                        ParticleHandler.particleOutburst((Level)world, 10, x, player.m_20186_() + 5.0, z, (ParticleOptions)ParticleTypes.f_123796_, new Vec3(4.0, 4.0, 4.0), 0.5f);
                    }
                    if (!player.m_7500_()) {
                        player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.COOLDOWN.get(), this.getScaledCooldownSummon(stack), 0));
                    }
                } else if (ConfigConstructor.inform_player_about_cooldown_effect) {
                    player.m_5661_((Component)Component.m_264568_((String)"soulsweapons.weapon.on_cooldown", (String)"Can't cast this ability with the Cooldown effect!"), true);
                }
            } else {
                AABB box = player.m_20191_().m_82400_(3.0);
                List entities = world.m_45933_((Entity)player, box);
                float power = ConfigConstructor.draupnir_spear_projectile_damage;
                for (Entity entity : entities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    entity.m_6469_(world.m_269111_().m_269333_((LivingEntity)player), power + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)((LivingEntity)entity).m_6336_()));
                    entity.m_5997_(0.0, (double)0.1f, 0.0);
                }
                ParticleHandler.particleOutburstMap((Level)world, 250, player.m_20185_(), player.m_20186_(), player.m_20189_(), ParticleEvents.DEFAULT_GRAND_SKYFALL_MAP, 0.5f);
                world.m_5594_(null, player.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.applyItemCooldown(player, this.getScaledCooldownExplode(stack));
                if (stack.m_41782_() && stack.m_41783_().m_128441_(SPEARS_ID)) {
                    int[] ids;
                    for (int id : ids = stack.m_41783_().m_128465_(SPEARS_ID)) {
                        Entity entity = world.m_6815_(id);
                        if (!(entity instanceof DraupnirSpearEntity)) continue;
                        DraupnirSpearEntity spear = (DraupnirSpearEntity)entity;
                        spear.detonate();
                    }
                    stack.m_41783_().m_128385_(SPEARS_ID, new int[0]);
                }
            }
        }
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, LocalPlayer player) {
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_draupnir_spear;
    }
}

