/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.scythe;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.UmbralTrespassItem;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class ShadowAssassinScythe
extends UmbralTrespassItem {
    private static final String HAS_EFFECT = "has_shadow_step";
    public static final int TICKS_FOR_BONUS = ConfigConstructor.shadow_assassin_scythe_shadow_step_ticks;

    public ShadowAssassinScythe(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.darkin_scythe_damage + ConfigConstructor.darkin_scythe_bonus_damage, ConfigConstructor.shadow_assassin_scythe_attack_speed, settings, ConfigConstructor.shadow_assassin_scythe_ticks_before_dismount);
        this.addTooltipAbility(TooltipAbilities.SHADOW_STEP);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        ItemCooldowns cooldownManager;
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        if (attacker instanceof Player && !(cooldownManager = (player = (Player)attacker).m_36335_()).m_41519_((Item)this)) {
            attacker.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.SHADOW_STEP.get(), TICKS_FOR_BONUS, Mth.m_14143_((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f))));
            cooldownManager.m_41524_((Item)this, ConfigConstructor.shadow_assassin_scythe_shadow_step_cooldown);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        LivingEntity living;
        super.m_6883_(stack, world, entity, slot, selected);
        stack.m_41784_().m_128379_(HAS_EFFECT, entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)EffectRegistry.SHADOW_STEP.get()));
    }

    private boolean canGetBonus(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(HAS_EFFECT) && !this.isDisabled(stack)) {
            return stack.m_41783_().m_128471_(HAS_EFFECT);
        }
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", this.canGetBonus(stack) ? (double)(this.m_43299_() + (float)ConfigConstructor.shadow_assassin_scythe_shadow_step_bonus_damage) : (double)this.m_43299_(), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.m_7167_(slot);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_shadow_assassin_scythe;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_shadow_assassin_scythe;
    }

    @Override
    public float getAbilityDamage() {
        return ConfigConstructor.shadow_assassin_scythe_ability_damage;
    }

    @Override
    public int getAbilityCooldown(ItemStack stack) {
        return Math.max(ConfigConstructor.shadow_assassin_scythe_ability_min_cooldown, ConfigConstructor.shadow_assassin_scythe_ability_cooldown - this.getReduceCooldownEnchantLevel(stack) * 25);
    }

    @Override
    public boolean shouldAbilityHeal() {
        return false;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.shadow_assassin_scythe_ability_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.shadow_assassin_scythe_ability_enchant_reduces_cooldown_ids;
    }
}

