/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.scythe;

import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.ForlornScytheRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.SoulHarvestingItem;
import net.soulsweaponry.util.TooltipAbilities;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ForlornScythe
extends SoulHarvestingItem
implements GeoItem {
    private static final String CRITICAL = "3rd_shot";
    private static final String PREV_UUID = "prev_projectile_uuid";
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ForlornScythe(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.forlorn_scythe_damage, ConfigConstructor.forlorn_scythe_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.SOUL_RELEASE_WITHER);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        int power;
        ItemStack stack = user.m_21120_(hand);
        if (this.isDisabled(stack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!world.f_46443_) {
            this.detonatePrevEntity((ServerLevel)world, stack);
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("kills") && ((power = this.getSouls(stack)) > 0 || user.m_7500_())) {
            WitherSkull entity = new WitherSkull(EntityType.f_20498_, world);
            entity.m_20343_(user.m_20185_(), user.m_20188_(), user.m_20189_());
            entity.m_5602_((Entity)user);
            if (this.isCritical(stack)) {
                entity.m_37629_(true);
                stack.m_41783_().m_128405_(CRITICAL, 1);
            } else {
                stack.m_41783_().m_128405_(CRITICAL, stack.m_41783_().m_128451_(CRITICAL) + 1);
            }
            entity.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 3.0f, 1.0f);
            world.m_7967_((Entity)entity);
            this.setPrevUuid(stack, (Entity)entity);
            if (!user.m_7500_()) {
                this.addAmount(stack, -1);
            }
            user.m_36335_().m_41524_((Item)this, 10);
            stack.m_41622_(1, (LivingEntity)user, p_220045_0_ -> p_220045_0_.m_21190_(hand));
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private void detonatePrevEntity(ServerLevel world, ItemStack stack) {
        UUID uuid;
        Entity entity;
        if (stack.m_41782_() && stack.m_41783_().m_128441_(PREV_UUID) && (entity = world.m_8791_(uuid = stack.m_41783_().m_128342_(PREV_UUID))) instanceof WitherSkull) {
            WitherSkull skull = (WitherSkull)entity;
            world.m_255391_((Entity)skull, skull.m_20185_(), skull.m_20186_(), skull.m_20189_(), skull.m_37635_() ? 2.0f : 1.0f, false, Level.ExplosionInteraction.MOB);
            skull.m_146870_();
        }
    }

    private void setPrevUuid(ItemStack stack, Entity entityToSet) {
        stack.m_41784_().m_128362_(PREV_UUID, entityToSet.m_20148_());
    }

    private boolean isCritical(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(CRITICAL)) {
            return stack.m_41783_().m_128451_(CRITICAL) >= 3;
        }
        stack.m_41784_().m_128405_(CRITICAL, 1);
        return false;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_forlorn_scythe;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private ForlornScytheRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new ForlornScytheRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_forlorn_scythe;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }
}

