/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.potion;

import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.registry.EffectRegistry;

public class CustomPotionItem
extends PotionItem {
    private final RegistryObject<Potion> potion;

    public CustomPotionItem(Item.Properties settings, RegistryObject<Potion> potion) {
        super(settings);
        this.potion = potion;
    }

    public List<MobEffectInstance> getEffects() {
        return ((Potion)this.potion.get()).m_43488_();
    }

    public Potion getPotion() {
        return (Potion)this.potion.get();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (!this.canUse(itemStack)) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return super.m_7203_(world, user, hand);
    }

    public InteractionResult m_6880_(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (entity.m_21023_((MobEffect)EffectRegistry.CHUNGUS_TONIC_EFFECT.get()) || !this.canUse(stack)) {
            return InteractionResult.FAIL;
        }
        for (MobEffectInstance effectInstance : this.getEffects()) {
            entity.m_7292_(effectInstance);
        }
        user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!user.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 0.5f, 0.4f / (user.m_9236_().m_213780_().m_188501_() * 0.4f + 0.8f));
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    public boolean canUse(ItemStack stack) {
        return ConfigConstructor.chungus_tonic_can_use;
    }
}

