/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.hammer;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.MjolnirItemRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.MjolnirProjectile;
import net.soulsweaponry.entity.projectile.noclip.WarmupLightningEntity;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Mjolnir
extends ChargeToUseItem
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String RAINING = "raining";

    public Mjolnir(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.mjolnir_damage, ConfigConstructor.mjolnir_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.MJOLNIR_LIGHTNING, TooltipAbilities.THROW_LIGHTNING, TooltipAbilities.RETURNING, TooltipAbilities.WEATHERBORN, TooltipAbilities.OFF_HAND_FLIGHT);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        int i = this.getChargeTime(stack, remainingUseTicks);
        if (user instanceof Player) {
            Player player = (Player)user;
            if (i >= 10) {
                int cooldown = 0;
                stack.m_41622_(3, (LivingEntity)player, p -> p.m_21190_(user.m_7655_()));
                if (player.m_6144_()) {
                    this.smashGround(stack, world, player);
                    this.lightningCall(player, world);
                    cooldown = ConfigConstructor.mjolnir_lightning_smash_cooldown;
                } else if (player.m_21206_().m_150930_((Item)this)) {
                    this.riptide(player, world, stack);
                    if (!world.m_46471_()) {
                        cooldown = ConfigConstructor.mjolnir_riptide_cooldown;
                    }
                } else {
                    this.throwHammer(world, player, stack);
                }
                if (cooldown != 0) {
                    cooldown = Math.max(ConfigConstructor.mjolnir_ability_min_cooldown, cooldown - this.getReduceCooldownEnchantLevel(stack) * 30);
                }
                this.applyItemCooldown(player, cooldown);
            }
        }
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.mjolnir_ability_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.mjolnir_ability_enchant_reduces_cooldown_ids;
    }

    private void throwHammer(Level world, Player player, ItemStack stack) {
        MjolnirProjectile projectile = new MjolnirProjectile(world, (LivingEntity)player, stack);
        projectile.saveOnPlayer(player);
        float speed = (float)WeaponUtil.getEnchantDamageBonus(stack) / 5.0f;
        projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f + speed, 1.0f);
        projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        world.m_7967_((Entity)projectile);
        world.m_6269_(null, (Entity)projectile, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!player.m_150110_().f_35937_) {
            player.m_150109_().m_36057_(stack);
        }
    }

    private void riptide(Player player, Level world, ItemStack stack) {
        float sharpness = WeaponUtil.getEnchantDamageBonus(stack);
        float f = player.m_146908_();
        float g = player.m_146909_();
        float h = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(g * ((float)Math.PI / 180)));
        float k = -Mth.m_14031_((float)(g * ((float)Math.PI / 180)));
        float l = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(g * ((float)Math.PI / 180)));
        float m = Mth.m_14116_((float)(h * h + k * k + l * l));
        float n = 3.0f * ((5.0f + sharpness) / 4.0f);
        player.m_5997_((double)(h *= n / m), (double)(k *= n / m), (double)(l *= n / m));
        player.m_204079_(20);
        if (player.m_20096_()) {
            player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
        }
        world.m_6269_(null, (Entity)player, SoundEvents.f_12519_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void smashGround(ItemStack stack, Level world, Player player) {
        AABB box = player.m_20191_().m_82400_(3.0);
        List entities = world.m_45933_((Entity)player, box);
        float power = ConfigConstructor.mjolnir_smash_damage;
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.m_6469_(world.m_269111_().m_269333_((LivingEntity)player), power + 2.0f * EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)((LivingEntity)entity).m_6336_()));
            entity.m_5997_(0.0, 0.25, 0.0);
        }
        world.m_6269_(null, (Entity)player, SoundEvents.f_12089_, SoundSource.PLAYERS, 0.75f, 1.0f);
        double d = player.m_217043_().m_188583_() * 0.05;
        double e = player.m_217043_().m_188583_() * 0.05;
        for (int j = 0; j < 200; ++j) {
            double newX = player.m_217043_().m_188500_() - 0.5 + player.m_217043_().m_188583_() * 0.15 + d;
            double newZ = player.m_217043_().m_188500_() - 0.5 + player.m_217043_().m_188583_() * 0.15 + e;
            double newY = player.m_217043_().m_188500_() - 0.5 + player.m_217043_().m_188500_() * 0.5;
            world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, Items.f_41905_.m_7968_()), player.m_20185_(), player.m_20186_(), player.m_20189_(), newX, newY / 2.0, newZ);
            world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, Items.f_42329_.m_7968_()), player.m_20185_(), player.m_20186_(), player.m_20189_(), newX, newY / 2.0, newZ);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, player.m_20185_(), player.m_20186_(), player.m_20189_(), newX, newY / 8.0, newZ);
            world.m_7106_((ParticleOptions)ParticleTypes.f_175830_, player.m_20185_(), player.m_20186_(), player.m_20189_(), newX * 10.0, newY * 2.0, newZ * 10.0);
        }
    }

    private void lightningCall(Player player, Level world) {
        for (int i = 1; i < ConfigConstructor.mjolnir_lightning_circle_amount + 1; ++i) {
            int r = 5 * i;
            for (int theta = 0; theta < 360; theta += 30) {
                double x0 = player.m_20185_();
                double z0 = player.m_20189_();
                double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
                double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
                WarmupLightningEntity entity = new WarmupLightningEntity((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.WARMUP_LIGHTNING.get()), world);
                entity.m_20343_(x, player.m_20186_(), z);
                entity.setWarmup(2 + i * 8);
                entity.m_5602_((Entity)player);
                world.m_7967_((Entity)entity);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        this.refreshRaining(world, stack);
    }

    private void refreshRaining(Level world, ItemStack stack) {
        stack.m_41784_().m_128379_(RAINING, world.m_46471_());
    }

    private boolean isRaining(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(RAINING)) {
            return stack.m_41783_().m_128471_(RAINING);
        }
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", this.isRaining(stack) && !this.isDisabled(stack) ? (double)(ConfigConstructor.mjolnir_rain_bonus_damage - 1 + ConfigConstructor.mjolnir_damage) : (double)(ConfigConstructor.mjolnir_damage - 1), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)(-(4.0f - ConfigConstructor.mjolnir_rain_total_attack_speed)), AttributeModifier.Operation.ADDITION));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.m_7167_(slot);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_mjolnir;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private MjolnirItemRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new MjolnirItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_mjolnir;
    }
}

