/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.gun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.SilverBulletEntity;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.items.ITooltipInfo;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import org.jetbrains.annotations.Nullable;

public abstract class GunItem
extends BowItem
implements IConfigDisable,
ITooltipInfo {
    public static final Predicate<ItemStack> SILVER_PROJECTILE = stack -> stack.m_150930_((Item)ItemRegistry.SILVER_BULLET.get());
    protected final List<TooltipAbilities> tooltipAbilities = new ArrayList<TooltipAbilities>();

    public GunItem(Item.Properties settings) {
        super(settings);
        this.addTooltipAbility(TooltipAbilities.GUN_ITEM);
    }

    public Predicate<ItemStack> m_6437_() {
        return SILVER_PROJECTILE;
    }

    public int getReducedCooldown(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.FAST_HANDS, (ItemStack)stack) * 8;
    }

    public abstract int getPostureLoss(ItemStack var1);

    public abstract float getBulletDamage(ItemStack var1);

    public abstract float getBulletVelocity(ItemStack var1);

    public abstract float getBulletDivergence(ItemStack var1);

    public abstract int getCooldown(ItemStack var1);

    public abstract int bulletsNeeded();

    public abstract boolean m_41475_();

    public int m_8105_(ItemStack stack) {
        return 0;
    }

    public AbstractArrow createSilverBulletEntity(Level world, LivingEntity shooter, ItemStack gunStack) {
        if (EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.MISFIRE_CURSE, (ItemStack)gunStack) > 0 && !world.f_46443_ && shooter.m_217043_().m_188500_() < ConfigConstructor.misfire_curse_enchant_trigger_chance) {
            world.m_255391_(null, shooter.m_20185_(), shooter.m_20227_(0.5), shooter.m_20189_(), 3.0f, true, Level.ExplosionInteraction.MOB);
            shooter.m_20254_(3);
        }
        float power = this.getBulletDamage(gunStack) / this.getBulletVelocity(gunStack) + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)gunStack) / 2.0f;
        int punch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)gunStack);
        int ethereal = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.ETHEREAL, (ItemStack)gunStack);
        int explosivePower = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.EXPLOSIVE_ROUNDS, (ItemStack)gunStack);
        int chainLightningLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.CHAIN_LIGHTNING, (ItemStack)gunStack);
        SilverBulletEntity entity = this.getModdedProjectile(world, shooter, gunStack);
        entity.m_20343_(shooter.m_20185_(), shooter.m_20188_() - (double)0.4f, shooter.m_20189_());
        entity.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        entity.m_36790_(ethereal > 0);
        entity.setEthereal(ethereal > 0);
        entity.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, this.getBulletVelocity(gunStack), this.getBulletDivergence(gunStack));
        entity.setPostureLoss(this.getPostureLoss(gunStack));
        entity.m_36781_(power);
        if (punch > 0) {
            entity.m_36735_(punch);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)gunStack) > 0) {
            entity.m_20254_(8);
        }
        if (explosivePower > 0) {
            entity.setExplosionPower(explosivePower);
        }
        if (chainLightningLevel > 0) {
            entity.setChainLightningDamage((float)chainLightningLevel * ConfigConstructor.chain_lightning_enchant_damage_per_level);
            entity.setChainLightningRange((float)chainLightningLevel * ConfigConstructor.chain_lightning_enchant_range_per_level);
        }
        return entity;
    }

    public SilverBulletEntity getModdedProjectile(Level world, LivingEntity shooter, ItemStack gunStack) {
        return new SilverBulletEntity(world, shooter, gunStack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.isDisabled(stack)) {
            tooltip.add((Component)Component.m_264568_((String)"tooltip.soulsweapons.disabled", (String)"Disabled"));
        }
        this.appendTooltipAbilities(stack, world, tooltip, context);
        super.m_7373_(stack, world, tooltip, context);
    }

    @Override
    public List<TooltipAbilities> getTooltipAbilities() {
        return this.tooltipAbilities;
    }

    @Override
    public void addTooltipAbility(TooltipAbilities ... abilities) {
        Collections.addAll(this.tooltipAbilities, abilities);
    }

    @Override
    public Component[] getAdditionalTooltips() {
        return new Component[0];
    }
}

