/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.crossbow;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.projectile_damage.api.IProjectileWeapon;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.arrow.TrueDamageArrow;
import net.soulsweaponry.items.ModdedCrossbow;
import net.soulsweaponry.util.TooltipAbilities;

public class KrakenSlayerCrossbow
extends ModdedCrossbow {
    public KrakenSlayerCrossbow(Item.Properties settings) {
        super(settings);
        this.addTooltipAbility(TooltipAbilities.FAST_PULL, TooltipAbilities.THIRD_SHOT);
        ((IProjectileWeapon)this).setProjectileDamage((double)ConfigConstructor.kraken_slayer_crossbow_damage);
        ((IProjectileWeapon)this).setCustomLaunchVelocity(Double.valueOf(ConfigConstructor.kraken_slayer_crossbow_max_velocity));
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_kraken_slayer_crossbow;
    }

    @Override
    public AbstractArrow getModifiedProjectile(Level world, ItemStack bowStack, ItemStack arrowStack, LivingEntity shooter, AbstractArrow originalArrow) {
        float bonus = (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)bowStack) / 4.0f;
        if (bowStack.m_41782_() && bowStack.m_41783_().m_128441_("firedShots") && bowStack.m_41783_().m_128451_("firedShots") >= 2) {
            TrueDamageArrow projectile = new TrueDamageArrow(world, shooter);
            projectile.setTrueDamage(ConfigConstructor.kraken_slayer_bonus_true_damage);
            projectile.m_36781_(originalArrow.m_36789_() + (double)bonus);
            bowStack.m_41783_().m_128405_("firedShots", 0);
            return projectile;
        }
        if (bowStack.m_41782_() && bowStack.m_41783_().m_128441_("firedShots")) {
            bowStack.m_41783_().m_128405_("firedShots", bowStack.m_41783_().m_128451_("firedShots") + 1);
        } else {
            bowStack.m_41784_().m_128405_("firedShots", 1);
        }
        originalArrow.m_36781_(originalArrow.m_36789_() + (double)bonus);
        return null;
    }

    @Override
    public int getPullTime() {
        return ConfigConstructor.kraken_slayer_crossbow_pull_time_ticks;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_kraken_slayer_crossbow;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }
}

