/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.bow;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.projectile_damage.api.IProjectileWeapon;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.arrow.SilverArrow;
import net.soulsweaponry.items.IPostureLossItem;
import net.soulsweaponry.items.IUndeadBonus;
import net.soulsweaponry.items.ModdedBow;
import net.soulsweaponry.util.TooltipAbilities;

public class SimonsBowblade
extends ModdedBow
implements IUndeadBonus,
IPostureLossItem {
    public SimonsBowblade(Item.Properties settings) {
        super(settings);
        this.addTooltipAbility(TooltipAbilities.RIGHTEOUS, TooltipAbilities.PROJECTILE_POSTURE_LOSS, TooltipAbilities.SLOW_PULL);
        ((IProjectileWeapon)this).setProjectileDamage((double)ConfigConstructor.simons_bowblade_projectile_damage);
        ((IProjectileWeapon)this).setCustomLaunchVelocity(Double.valueOf(ConfigConstructor.simons_bowblade_max_velocity));
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_simons_bowblade;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }

    @Override
    public AbstractArrow getModifiedProjectile(Level world, ItemStack bowStack, ItemStack arrowStack, LivingEntity shooter, AbstractArrow originalArrow) {
        SilverArrow arrow = new SilverArrow(shooter, world);
        arrow.setBonusUndeadDamage(this.getUndeadBonus(bowStack) + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)bowStack));
        arrow.setPostureLoss(this.getPostureLoss());
        return arrow;
    }

    @Override
    public int getPullTime() {
        return ConfigConstructor.simons_bowblade_pull_time_ticks;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_simons_bowblade;
    }

    @Override
    public boolean isRighteous() {
        return true;
    }

    @Override
    public float getUndeadBonus(ItemStack stack) {
        return ConfigConstructor.simons_bowblade_projectile_righteous_undead_bonus_damage;
    }

    @Override
    public int getPostureLoss() {
        return ConfigConstructor.simons_bowblade_projectile_posture_loss;
    }
}

