/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.bow;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.projectile_damage.api.IProjectileWeapon;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.arrow.ChargedArrow;
import net.soulsweaponry.items.ModdedBow;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import org.jetbrains.annotations.Nullable;

public class Galeforce
extends ModdedBow
implements IKeybindAbility {
    public Galeforce(Item.Properties settings) {
        super(settings);
        this.addTooltipAbility(TooltipAbilities.GALEFORCE);
        ((IProjectileWeapon)this).setProjectileDamage((double)ConfigConstructor.galeforce_damage);
        ((IProjectileWeapon)this).setCustomLaunchVelocity(Double.valueOf(ConfigConstructor.galeforce_max_velocity));
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_galeforce;
    }

    @Override
    @Nullable
    public AbstractArrow getModifiedProjectile(Level world, ItemStack bowStack, ItemStack arrowStack, LivingEntity shooter, AbstractArrow originalArrow) {
        shooter.m_7292_(new MobEffectInstance(MobEffects.f_19596_, ConfigConstructor.galeforce_speed_effect_duration_ticks, ConfigConstructor.galeforce_speed_effect_amplifier - 1));
        return new ChargedArrow(world, shooter, false);
    }

    @Override
    public int getPullTime() {
        return ConfigConstructor.galeforce_pull_time_ticks;
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        if (!player.m_21023_((MobEffect)EffectRegistry.COOLDOWN.get())) {
            ItemStack arrowStack;
            if (!player.m_7500_()) {
                int cooldown = Math.max(ConfigConstructor.galeforce_dash_min_cooldown, ConfigConstructor.galeforce_dash_cooldown - this.getReduceCooldownEnchantLevel(stack) * 8);
                player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.COOLDOWN.get(), cooldown, 0));
            }
            if ((arrowStack = player.m_6298_(stack)).m_41619_()) {
                arrowStack = new ItemStack((ItemLike)Items.f_42412_);
            }
            if (player.m_21214_() != null) {
                LivingEntity target = player.m_21214_();
                double x = target.m_20185_() - player.m_20185_();
                double y = target.m_20188_() - player.m_20227_(1.0);
                double z = target.m_20189_() - player.m_20189_();
                this.shootArrow(world, stack, arrowStack, player, new Vec3(x, y, z));
            } else {
                this.shootArrow(world, stack, arrowStack, player, null);
            }
        }
    }

    private void shootArrow(ServerLevel world, ItemStack stack, ItemStack arrowStack, Player player, @Nullable Vec3 currentTargetPos) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, ConfigConstructor.galeforce_speed_effect_duration_ticks, ConfigConstructor.galeforce_speed_effect_amplifier - 1));
        ChargedArrow chargedArrow = new ChargedArrow((Level)world, (LivingEntity)player, true);
        if (chargedArrow.canHaveArrowEffects(arrowStack, stack)) {
            chargedArrow.m_36878_(arrowStack);
        }
        chargedArrow.m_20343_(player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_());
        if (currentTargetPos != null) {
            chargedArrow.m_6686_(currentTargetPos.m_7096_(), currentTargetPos.m_7098_(), currentTargetPos.m_7094_(), ConfigConstructor.galeforce_max_velocity, 1.0f);
        } else {
            chargedArrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, ConfigConstructor.galeforce_max_velocity, 1.0f);
        }
        chargedArrow.m_36762_(true);
        double damage = (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack) * 0.6f + (float)ConfigConstructor.galeforce_damage / ConfigConstructor.galeforce_max_velocity;
        chargedArrow.m_36781_(damage);
        int punch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack);
        if (punch > 0) {
            chargedArrow.m_36735_(punch);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            chargedArrow.m_20254_(8);
        }
        stack.m_41622_(1, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(player.m_7655_()));
        chargedArrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        world.m_7967_((Entity)chargedArrow);
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.m_213780_().m_188501_() * 0.4f + 1.2f) + 0.5f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, LocalPlayer player) {
        if (!player.m_21023_((MobEffect)EffectRegistry.COOLDOWN.get())) {
            float f = player.m_146908_();
            float g = player.m_146909_();
            float h = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(g * ((float)Math.PI / 180)));
            float k = -Mth.m_14031_((float)(g * ((float)Math.PI / 180)));
            float l = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(g * ((float)Math.PI / 180)));
            float m = Mth.m_14116_((float)(h * h + k * k + l * l));
            float n = 1.5f;
            player.m_5997_((double)(h *= n / m), (double)(k *= n / m), (double)(l *= n / m));
        }
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_galeforce;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.galeforce_dash_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.galeforce_dash_enchant_reduces_cooldown_ids;
    }
}

