/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.items.ICooldownItem;
import net.soulsweaponry.items.ITooltipInfo;
import net.soulsweaponry.util.TooltipAbilities;
import org.jetbrains.annotations.Nullable;

public abstract class ModdedSword
extends SwordItem
implements IConfigDisable,
ICooldownItem,
ITooltipInfo {
    protected final float attackSpeed;
    protected final List<TooltipAbilities> tooltipAbilities = new ArrayList<TooltipAbilities>();

    public ModdedSword(Tier toolMaterial, int attackDamage, float ingameAttackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, -(4.0f - ingameAttackSpeed), settings);
        this.attackSpeed = -(4.0f - ingameAttackSpeed);
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public List<TooltipAbilities> getTooltipAbilities() {
        return this.tooltipAbilities;
    }

    @Override
    public void addTooltipAbility(TooltipAbilities ... abilities) {
        Collections.addAll(this.tooltipAbilities, abilities);
    }

    @Override
    public Component[] getAdditionalTooltips() {
        return new Component[0];
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.isDisabled(stack)) {
            tooltip.add((Component)Component.m_264568_((String)"tooltip.soulsweapons.disabled", (String)"Disabled"));
        }
        this.appendTooltipAbilities(stack, world, tooltip, context);
        super.m_7373_(stack, world, tooltip, context);
    }

    public void notifyCooldown(LivingEntity user) {
        if (!ConfigConstructor.inform_player_about_cooldown_effect) {
            return;
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            player.m_5661_((Component)Component.m_264568_((String)"soulsweapons.weapon.on_cooldown", (String)"Can't cast this ability with the Cooldown effect!"), true);
        } else {
            user.m_213846_((Component)Component.m_264568_((String)"soulsweapons.weapon.on_cooldown", (String)"Can't cast this ability with the Cooldown effect!"));
        }
    }

    public abstract boolean m_41475_();
}

