/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.events;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.soulsweaponry.api.trickweapon.TrickWeaponUtil;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.ParryData;
import net.soulsweaponry.entitydata.ReturningProjectileData;
import net.soulsweaponry.entitydata.posture.PostureData;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;

@Mod.EventBusSubscriber(modid="soulsweapons")
public class ModEvents {
    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        TrickWeaponUtil.loadMappings(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            PostureData.setPosture((LivingEntity)newPlayer, PostureData.getPosture((LivingEntity)oldPlayer));
            CompoundTag oldData = oldPlayer.getPersistentData();
            CompoundTag newData = newPlayer.getPersistentData();
            if (oldData.m_128441_("returning_projectile_uuid") && newPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)newPlayer;
                UUID uuid = oldData.m_128342_("returning_projectile_uuid");
                newData.m_128362_("returning_projectile_uuid", uuid);
                ReturningProjectileData.syncData(uuid, serverPlayerEntity);
            }
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        int parryFrames;
        if (event.side == LogicalSide.SERVER && (parryFrames = ParryData.getParryFrames(player = event.player)) >= 1) {
            ParryData.addParryFrames(player, 1);
            player.m_21253_();
        }
    }

    @SubscribeEvent
    public static void onLivingEntityTicks(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        int posture = PostureData.getPosture(entity);
        if (posture >= ConfigConstructor.max_posture_loss) {
            if (!entity.m_21023_((MobEffect)EffectRegistry.POSTURE_BREAK.get())) {
                entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.POSTURE_BREAK_EVENT.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.POSTURE_BREAK.get(), 60, 1));
            PostureData.setPosture(entity, 0);
        } else if (posture > 0 && entity.f_19797_ % 4 == 0) {
            PostureData.reducePosture(entity, 1);
        }
    }
}

