/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.events;

import net.minecraft.client.particle.FlameParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.soulsweaponry.client.hud.CustomBossBar;
import net.soulsweaponry.client.hud.PostureHudOverlay;
import net.soulsweaponry.client.particles.factory.SoulSparkFactory;
import net.soulsweaponry.client.registry.BlockRenderLayers;
import net.soulsweaponry.client.registry.EntityModelLayerModRegistry;
import net.soulsweaponry.client.registry.EntityModelRegistry;
import net.soulsweaponry.client.registry.KeyBindRegistry;
import net.soulsweaponry.client.registry.PredicateRegistry;
import net.soulsweaponry.registry.ParticleRegistry;

@Mod.EventBusSubscriber(modid="soulsweapons", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModBusEvents {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            BlockRenderLayers.register();
            PredicateRegistry.register();
            EntityModelRegistry.register();
            CustomBossBar.init();
        });
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleRegistry.NIGHTFALL_PARTICLE.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.DAZZLING_PARTICLE.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.PURPLE_FLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.DARK_STAR.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.BLACK_FLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.SUN_PARTICLE.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.MOONVEIL_PARTICLE.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.BLUE_FLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.SOUL_SPARK.get(), SoulSparkFactory::new);
    }

    @SubscribeEvent
    public static void onKeyRegister(RegisterKeyMappingsEvent event) {
        KeyBindRegistry.register(event);
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("posture_bar", PostureHudOverlay.HUD_POSTURE);
    }

    @SubscribeEvent
    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        EntityModelLayerModRegistry.initClient(event);
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent event) {
        if (event.getAtlas().m_118330_().equals((Object)new ResourceLocation("minecraft", "textures/atlas/blocks"))) {
            event.getAtlas().getTextureLocations().add(new ResourceLocation("soulsweapons", "block/pruified_blood_still"));
            event.getAtlas().getTextureLocations().add(new ResourceLocation("soulsweapons", "block/pruified_blood_flow"));
        }
    }
}

