/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.noclip;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.soulsweaponry.entity.projectile.noclip.NoClipEntity;

public abstract class DamagingNoClipEntity
extends NoClipEntity {
    private final Set<UUID> entitiesHit = new HashSet<UUID>();
    public final int maxAge;

    public DamagingNoClipEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
        this.maxAge = 100;
    }

    public DamagingNoClipEntity(EntityType<? extends AbstractArrow> entityType, Level world, LivingEntity owner, int maxAge) {
        super(entityType, world);
        this.maxAge = maxAge;
        this.m_5602_((Entity)owner);
    }

    public void m_8119_() {
        this.m_146926_(0.0f);
        this.m_146922_(0.0f);
        super.m_8119_();
        this.m_146926_(0.0f);
        this.m_146922_(0.0f);
        if (!this.m_9236_().f_46443_) {
            List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.4));
            for (LivingEntity living : list) {
                if (this.m_150171_((Entity)living) || this.entitiesHit.contains(living.m_20148_())) continue;
                this.updateEntityDamage(living);
                boolean wasHit = this.m_19749_() instanceof LivingEntity ? living.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, (LivingEntity)this.m_19749_()), (float)this.m_36789_()) : living.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, null), (float)this.m_36789_());
                this.applyDamageEffects(wasHit, living);
                this.entitiesHit.add(living.m_20148_());
            }
        }
        if (this.f_19797_ > this.maxAge) {
            this.m_146870_();
        }
    }

    public abstract void applyDamageEffects(boolean var1, LivingEntity var2);

    public void updateEntityDamage(LivingEntity target) {
        this.m_36781_(this.m_36789_() + (double)EnchantmentHelper.m_44833_((ItemStack)this.getStack(), (MobType)target.m_6336_()));
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("EntitiesHit", 9)) {
            ListTag list = nbt.m_128437_("EntitiesHit", 10);
            this.entitiesHit.clear();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.m_128728_(i);
                this.entitiesHit.add(tag.m_128342_("UUID"));
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag list = new ListTag();
        for (UUID uuid : this.entitiesHit) {
            list.add((Object)this.saveUuid(uuid));
        }
        nbt.m_128365_("EntitiesHit", (Tag)list);
    }

    private CompoundTag saveUuid(UUID uuid) {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("UUID", uuid);
        return tag;
    }
}

