/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.IPostureLossProjectile;
import net.soulsweaponry.entity.projectile.NonArrowProjectile;
import net.soulsweaponry.items.abilities.ChainLightning;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class SilverBulletEntity
extends NonArrowProjectile
implements GeoEntity,
IPostureLossProjectile {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int postureLoss;
    private boolean isEthereal;
    private float explosionPower;
    private float chainLightningDamage;
    private float chainLightningRange;

    public SilverBulletEntity(EntityType<? extends SilverBulletEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SilverBulletEntity(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.SILVER_BULLET_ENTITY_TYPE.get()), owner, world, stack);
    }

    public SilverBulletEntity(EntityType<? extends SilverBulletEntity> entityType, Level world, LivingEntity owner, ItemStack stack) {
        super(entityType, owner, world, stack);
    }

    public void m_8119_() {
        if (this.m_36797_()) {
            this.m_146926_(0.0f);
            this.m_146922_(0.0f);
            Vec3 currentPos = this.m_20182_();
            Vec3 velocity = this.m_20184_();
            Vec3 nextPos = currentPos.m_82549_(velocity);
            EntityHitResult entityHit = ProjectileUtil.m_37287_((Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)this.m_20191_().m_82369_(velocity).m_82400_(1.0), e -> e instanceof LivingEntity && e != this.m_19749_(), (double)5.0);
            if (entityHit != null) {
                this.m_5790_(entityHit);
                return;
            }
        }
        super.m_8119_();
        if (this.m_36797_()) {
            this.m_146926_(0.0f);
            this.m_146922_(0.0f);
        }
        if (!this.f_36703_) {
            Vec3 vec3d = this.m_20184_();
            double e2 = vec3d.f_82479_;
            double f = vec3d.f_82480_;
            double g = vec3d.f_82481_;
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + e2 * (double)i / 4.0, this.m_20186_() + f * (double)i / 4.0 + 0.25, this.m_20189_() + g * (double)i / 4.0, -e2 * 0.2, (-f + 0.2) * 0.2, -g * 0.2);
            }
        }
        if (this.f_19797_ > this.getMaxAge()) {
            this.m_146870_();
        }
    }

    public boolean m_20068_() {
        return true;
    }

    public void setEthereal(boolean ethereal) {
        this.isEthereal = ethereal;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12442_;
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_146870_();
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            Entity entity2;
            LivingEntity target = (LivingEntity)entity;
            this.applyPostureLoss(target);
            if (target.m_21222_()) {
                this.m_36781_(this.m_36789_() + (double)ConfigConstructor.silver_bullet_undead_bonus_damage / this.m_20184_().m_82553_());
            }
            if ((entity2 = this.m_19749_()) instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                if (this.chainLightningDamage > 0.0f) {
                    ChainLightning.trigger(this.m_9236_(), target, owner, false, this.getChainLightningDamage(), this.getChainLightningRange());
                }
            }
        }
        super.m_5790_(entityHitResult);
        if (this.explosionPower > 0.0f && !this.m_9236_().f_46443_) {
            ParticleHandler.particleOutburst(this.m_9236_(), 30, this.m_20185_(), this.m_20186_(), this.m_20189_(), (ParticleOptions)ParticleTypes.f_123746_, new Vec3(1.0, 1.0, 1.0), 0.6f);
            this.m_9236_().m_254849_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionPower, Level.ExplosionInteraction.MOB);
        }
        this.m_146870_();
    }

    public int getMaxAge() {
        if (this.isEthereal) {
            return 25;
        }
        return 100;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected ItemStack m_7941_() {
        return ((Item)ItemRegistry.SILVER_BULLET.get()).m_7968_();
    }

    @Override
    public void setPostureLoss(int postureLoss) {
        this.postureLoss = postureLoss;
    }

    @Override
    public int getPostureLoss() {
        return this.postureLoss;
    }

    public void setExplosionPower(float explosionPower) {
        this.explosionPower = explosionPower;
    }

    public void setChainLightningDamage(float chainLightningDamage) {
        this.chainLightningDamage = chainLightningDamage;
    }

    public float getChainLightningDamage() {
        return this.chainLightningDamage;
    }

    public void setChainLightningRange(float chainLightningRange) {
        this.chainLightningRange = chainLightningRange;
    }

    public float getChainLightningRange() {
        return this.chainLightningRange;
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("postureLoss")) {
            this.setPostureLoss(nbt.m_128451_("postureLoss"));
        }
        if (nbt.m_128441_("ethereal")) {
            this.isEthereal = nbt.m_128471_("ethereal");
        }
        if (nbt.m_128441_("explosionPower")) {
            this.explosionPower = nbt.m_128457_("explosionPower");
        }
        if (nbt.m_128441_("chainLightningDamage")) {
            this.chainLightningDamage = nbt.m_128457_("chainLightningDamage");
        }
        if (nbt.m_128441_("chainLightningRange")) {
            this.chainLightningRange = nbt.m_128457_("chainLightningRange");
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("postureLoss", this.getPostureLoss());
        nbt.m_128379_("ethereal", this.isEthereal);
        nbt.m_128350_("explosionPower", this.explosionPower);
        nbt.m_128350_("chainLightningDamage", this.chainLightningDamage);
        nbt.m_128350_("chainLightningRange", this.chainLightningRange);
    }
}

