/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.entity.mobs.ChaosMonarch;
import net.soulsweaponry.entity.mobs.NightShade;
import net.soulsweaponry.items.armor.ChaosSet;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class ShadowOrb
extends Fireball
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final MobEffect[] effects;

    public ShadowOrb(EntityType<? extends ShadowOrb> entityType, Level world) {
        super(entityType, world);
        this.effects = new MobEffect[]{MobEffects.f_19615_, (MobEffect)EffectRegistry.DECAY.get()};
    }

    public ShadowOrb(Level world, LivingEntity owner, double velocityX, double velocityY, double velocityZ, MobEffect ... effects) {
        super((EntityType)EntityRegistry.SHADOW_ORB.get(), owner, velocityX, velocityY, velocityZ, world);
        this.effects = effects;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (this.m_19749_() instanceof LivingEntity) {
                target.m_6469_(CustomDamageSource.create(this.m_9236_(), CustomDamageSource.SHADOW_ORB, (Entity)this, this.m_19749_()), 5.0f);
                for (MobEffect effect : this.effects) {
                    target.m_7292_(new MobEffectInstance(effect, 150, 0));
                }
            }
        }
        super.m_5790_(entityHitResult);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3d = this.m_20184_();
        double d = this.m_20185_() + vec3d.f_82479_;
        double e = this.m_20186_() + vec3d.f_82480_;
        double f = this.m_20189_() + vec3d.f_82481_;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, d + this.f_19796_.m_188500_() - 0.5, e + this.f_19796_.m_188500_() - 0.5, f + this.f_19796_.m_188500_() - 0.5, 0.0, 0.0, 0.0);
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.m_9236_().f_46443_) {
            ParticleHandler.particleSphereList(this.m_9236_(), 10, this.m_20185_(), this.m_20186_(), this.m_20189_(), ParticleEvents.DARK_EXPLOSION_LIST, 0.2f);
            this.m_146870_();
        }
    }

    protected boolean m_5603_(Entity entity) {
        if (entity instanceof ChaosMonarch || entity instanceof NightShade || this.m_150171_(entity)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            for (ItemStack stack : target.m_6168_()) {
                if (!(stack.m_41720_() instanceof ChaosSet)) continue;
                return false;
            }
        }
        return super.m_5603_(entity);
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

