/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class NonArrowProjectile
extends AbstractArrow {
    private ItemStack stackShotFrom;

    public NonArrowProjectile(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public NonArrowProjectile(EntityType<? extends AbstractArrow> type, double x, double y, double z, Level world) {
        this(type, world);
        this.m_6034_(x, y, z);
    }

    public NonArrowProjectile(EntityType<? extends AbstractArrow> type, LivingEntity owner, Level world, ItemStack stack) {
        this(type, owner.m_20185_(), owner.m_20188_() - (double)0.1f, owner.m_20189_(), world);
        this.m_5602_((Entity)owner);
        if (owner instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
        this.setItemStack(stack);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        DamageSource damageSource;
        Entity entity2;
        Entity entity = entityHitResult.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.m_36789_()), (double)0.0, (double)2.147483647E9));
        if (this.m_36792_()) {
            long l = this.f_19796_.m_188503_(i / 2 + 2);
            i = (int)Math.min(l + (long)i, Integer.MAX_VALUE);
        }
        if ((entity2 = this.m_19749_()) == null) {
            damageSource = this.m_9236_().m_269111_().m_269418_((AbstractArrow)this, (Entity)this);
        } else {
            damageSource = this.m_9236_().m_269111_().m_269418_((AbstractArrow)this, entity2);
            if (entity2 instanceof LivingEntity) {
                ((LivingEntity)entity2).m_21335_(entity);
            }
        }
        boolean bl = entity.m_6095_() == EntityType.f_20566_;
        int j = entity.m_20094_();
        if (this.m_6060_() && !bl) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(damageSource, (float)i)) {
            if (bl) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.m_150123_() > 0) {
                    double d = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                    Vec3 vec3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.m_150123_() * 0.6 * d);
                    if (vec3d.m_82556_() > 0.0) {
                        livingEntity.m_5997_(vec3d.f_82479_, 0.1, vec3d.f_82481_);
                    }
                }
                if (!this.m_9236_().f_46443_ && entity2 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)entity2);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity2), (Entity)livingEntity);
                }
                this.m_7761_(livingEntity);
                if (livingEntity != entity2 && livingEntity instanceof Player && entity2 instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)entity2).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
            }
            this.m_5496_(this.m_36784_(), 1.0f, 1.0f - this.f_19796_.m_188501_() / 2.0f);
            if (this.m_36796_() <= 0) {
                this.m_146870_();
            }
        } else {
            entity.m_7311_(j);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.m_9236_().f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
    }

    protected ItemStack m_7941_() {
        return this.stackShotFrom;
    }

    public void setItemStack(ItemStack stackShotFrom) {
        this.stackShotFrom = stackShotFrom;
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Stack", 10)) {
            this.stackShotFrom = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Stack"));
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.stackShotFrom != null) {
            nbt.m_128365_("Stack", (Tag)this.stackShotFrom.m_41739_(new CompoundTag()));
        }
    }
}

