/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.IAnimatedDeath;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class WitheredDemon
extends Monster
implements GeoEntity,
IAnimatedDeath {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private static final EntityDataAccessor<Boolean> SWING_ARM = SynchedEntityData.m_135353_(WitheredDemon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DEATH = SynchedEntityData.m_135353_(WitheredDemon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public WitheredDemon(EntityType<? extends WitheredDemon> entityType, Level world) {
        super(entityType, world);
        this.f_19811_ = true;
        this.f_21364_ = 20;
    }

    private PlayState predicate(AnimationState<?> state) {
        if (this.getDeath()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("death"));
        } else if (this.getSwingArm()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("attack"));
        } else if (this.m_5912_()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("walk"));
        } else {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        }
        return PlayState.CONTINUE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SWING_ARM, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(DEATH, (Object)Boolean.FALSE);
    }

    public boolean getSwingArm() {
        return (Boolean)this.f_19804_.m_135370_(SWING_ARM);
    }

    public void setSwingArm(boolean bl) {
        this.f_19804_.m_135381_(SWING_ARM, (Object)bl);
    }

    public boolean getDeath() {
        return (Boolean)this.f_19804_.m_135370_(DEATH);
    }

    public void setDeath(boolean bl) {
        this.f_19804_.m_135381_(DEATH, (Object)bl);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public boolean m_5825_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new DemonAttackGoal(this, 1.7, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, target -> {
            boolean bl = true;
            for (ItemStack stack : target.m_6168_()) {
                if (!stack.m_150930_((Item)ItemRegistry.WITHERED_CHEST.get()) && !stack.m_150930_((Item)ItemRegistry.ENHANCED_WITHERED_CHEST.get())) continue;
                bl = false;
                break;
            }
            return bl;
        }));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        super.m_8099_();
    }

    public static AttributeSupplier.Builder createDemonAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22276_, ConfigConstructor.withered_demon_health).m_22268_(Attributes.f_22284_, ConfigConstructor.withered_demon_armor).m_22268_(Attributes.f_22279_, 0.12).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 2.0);
    }

    public boolean m_6914_(LevelReader view) {
        BlockPos blockUnderEntity = new BlockPos(this.m_146903_(), this.m_146904_() - 1, this.m_146907_());
        BlockPos positionEntity = new BlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_());
        BlockState state = this.m_9236_().m_8055_(positionEntity);
        return view.m_45784_((Entity)this) && !this.m_9236_().m_46855_(this.m_20191_()) && state.m_60734_().m_48673_(state) && !this.m_9236_().m_8055_(positionEntity.m_7495_()).m_60713_(Blocks.f_50451_) && this.m_9236_().m_46791_() != Difficulty.PEACEFUL && this.m_9236_().m_8055_(positionEntity.m_7495_()).m_60713_(Blocks.f_50699_) && this.m_9236_().m_8055_(blockUnderEntity).m_60643_((BlockGetter)view, blockUnderEntity, (EntityType)EntityRegistry.WITHERED_DEMON.get()) && this.isSpawnable();
    }

    public boolean isSpawnable() {
        return ConfigConstructor.can_withered_demon_spawn;
    }

    @Override
    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.setDeath();
    }

    @Override
    public void setDeath() {
        this.setDeath(true);
    }

    @Override
    public int getTicksUntilDeath() {
        return 40;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_7327_(Entity target) {
        float f = this.getAttackDamage();
        float g = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        boolean bl = target.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), g);
        if (bl) {
            target.m_20256_(target.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
            this.m_19970_((LivingEntity)this, target);
        }
        return bl;
    }

    public boolean m_213824_() {
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        Random random = new Random();
        double ran = random.nextDouble();
        if (ran < 0.05) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + (double)1.4f, this.m_20189_(), ran - 0.025, ran - 0.025, ran - 0.025);
        }
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.DEMON_IDLE_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.DEMON_DAMAGE_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.DEMON_DEATH_EVENT.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)SoundRegistry.DEMON_WALK_EVENT.get();
    }

    public boolean m_21222_() {
        return true;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    static class DemonAttackGoal
    extends MeleeAttackGoal {
        private final WitheredDemon mob;
        private int attackStatus;

        public DemonAttackGoal(WitheredDemon mob, double speed, boolean pauseWhenMobIdle) {
            super((PathfinderMob)mob, speed, pauseWhenMobIdle);
            this.mob = mob;
        }

        private boolean canAttackTarget() {
            boolean bl = true;
            if (this.mob.m_5448_() != null && this.mob.m_21188_() != this.mob.m_5448_()) {
                for (ItemStack stack : this.mob.m_5448_().m_6168_()) {
                    if (!stack.m_150930_((Item)ItemRegistry.WITHERED_CHEST.get()) && !stack.m_150930_((Item)ItemRegistry.ENHANCED_WITHERED_CHEST.get())) continue;
                    bl = false;
                    break;
                }
            }
            return bl;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.canAttackTarget();
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.canAttackTarget();
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
            this.mob.setSwingArm(false);
        }

        protected void m_6739_(LivingEntity target, double squaredDistance) {
            double attackDistance = this.m_6639_(target);
            if (squaredDistance <= attackDistance && this.m_25565_() <= 0) {
                this.mob.setSwingArm(true);
            }
            if (this.mob.getSwingArm()) {
                ++this.attackStatus;
                if (this.attackStatus == 10 && squaredDistance <= attackDistance) {
                    this.mob.m_7327_((Entity)target);
                }
                if (this.attackStatus >= 30) {
                    this.mob.setSwingArm(false);
                    this.attackStatus = 0;
                    this.m_25563_();
                }
            }
        }
    }
}

