/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.NightShadeGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NightShade
extends BossEntity
implements GeoEntity,
TraceableEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int spawnTicks;
    public int deathTicks;
    private boolean isCopy = false;
    private boolean healthUpdated = false;
    private boolean hasDuplicated = false;
    private int duplicateTicks;
    private UUID ownerUuid;
    protected static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(NightShade.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(NightShade.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<BlockPos> POS = SynchedEntityData.m_135353_(NightShade.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public NightShade(EntityType<? extends NightShade> entityType, Level world) {
        super(entityType, world, BossEvent.BossBarColor.BLUE);
        this.f_21342_ = new ShadeMoveControl(this);
    }

    public static AttributeSupplier.Builder createBossAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 65.0).m_22268_(Attributes.f_22276_, ConfigConstructor.frenzied_shade_health).m_22268_(Attributes.f_22284_, ConfigConstructor.frenzied_shade_armor).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 10.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new NightShadeGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new Emerge());
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(POS, (Object)new BlockPos(0, 0, 0));
    }

    @Nullable
    public Entity m_19749_() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.ownerUuid != null) {
                return serverWorld.m_8791_(this.ownerUuid);
            }
        }
        return null;
    }

    public void setTargetPos(BlockPos pos) {
        this.f_19804_.m_135381_(POS, (Object)pos);
    }

    public BlockPos getTargetPos() {
        return (BlockPos)this.f_19804_.m_135370_(POS);
    }

    public void m_6478_(MoverType movementType, Vec3 movement) {
        super.m_6478_(movementType, movement);
        this.m_20101_();
    }

    @Override
    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
        if (this.isCopy) {
            this.bossBar.m_8321_(false);
            if (!this.healthUpdated) {
                this.m_21153_((float)ConfigConstructor.frenzied_shade_health / 4.0f);
                this.healthUpdated = true;
            }
            this.f_21364_ = 20;
        }
        if (this.m_19749_() != null && !this.m_19749_().m_6084_()) {
            this.setDeath();
            this.m_21153_(0.0f);
        }
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)SoundRegistry.FRENZIED_SHADE_SONG.get();
    }

    @Override
    public boolean hasBossMusic() {
        return !this.isCopy;
    }

    protected boolean m_6125_() {
        return !this.isCopy();
    }

    public void m_8107_() {
        int i;
        super.m_8107_();
        if (this.isSpawning()) {
            ++this.spawnTicks;
            if (this.spawnTicks >= 40) {
                this.setAttackState(AttackStates.IDLE);
            }
        }
        for (i = 0; i < 3; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        if (!this.isCopy && !this.hasDuplicated && this.m_21223_() <= this.m_21233_() / 2.0f) {
            this.setAttackState(AttackStates.DUPLICATE);
            ++this.duplicateTicks;
            if (this.duplicateTicks == 20) {
                CustomDeathHandler.deathExplosionEvent(this.m_9236_(), this.m_20182_(), (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), new ParticleOptions[]{ParticleTypes.f_123755_, (ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get(), (ParticleOptions)ParticleRegistry.DARK_STAR.get()});
                this.m_21573_().m_26573_();
                for (i = -1; i <= 1; i += 2) {
                    NightShade copy = new NightShade((EntityType<? extends NightShade>)((EntityType)EntityRegistry.NIGHT_SHADE.get()), this.m_9236_());
                    copy.ownerUuid = this.m_20148_();
                    copy.setCopy(true);
                    copy.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    copy.m_20334_((float)i / 10.0f, (float)i / 10.0f, -((float)i) / 10.0f);
                    copy.setSpawn();
                    copy.m_6710_(this.m_5448_());
                    this.m_9236_().m_7967_((Entity)copy);
                    NightShade copy2 = new NightShade((EntityType<? extends NightShade>)((EntityType)EntityRegistry.NIGHT_SHADE.get()), this.m_9236_());
                    copy2.ownerUuid = this.m_20148_();
                    copy2.setCopy(true);
                    copy2.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    copy2.m_20334_(-((float)i) / 10.0f, (float)i / 10.0f, (float)i / 10.0f);
                    copy2.setSpawn();
                    copy2.m_6710_(this.m_5448_());
                    this.m_9236_().m_7967_((Entity)copy2);
                }
            }
            if (this.duplicateTicks >= 60) {
                this.hasDuplicated = true;
                this.setAttackState(AttackStates.IDLE);
            }
        }
    }

    public boolean isCopy() {
        return this.isCopy;
    }

    @Override
    public void setDeath() {
        this.setAttackState(AttackStates.DEATH);
    }

    @Override
    public int getTicksUntilDeath() {
        return 60;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void m_6153_() {
        ++this.deathTicks;
        if (this.deathTicks % 30 == 0) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12554_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.m_9236_().m_5776_()) {
            if (this.isCopy) {
                this.m_9236_().m_7605_((Entity)this, (byte)60);
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.m_9236_(), this.m_20182_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), new ParticleOptions[]{ParticleTypes.f_123755_, (ParticleOptions)ParticleRegistry.NIGHTFALL_PARTICLE.get(), (ParticleOptions)ParticleRegistry.DARK_STAR.get()});
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void setAttackState(AttackStates state) {
        for (int i = 0; i < AttackStates.values().length; ++i) {
            if (AttackStates.values()[i] != state) continue;
            this.f_19804_.m_135381_(ATTACK_STATE, (Object)i);
        }
    }

    public AttackStates getAttackState() {
        return AttackStates.values()[(Integer)this.f_19804_.m_135370_(ATTACK_STATE)];
    }

    public boolean getCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    @Override
    public boolean isSpawning() {
        return this.getAttackState().equals((Object)AttackStates.SPAWN);
    }

    public void setSpawn() {
        this.setAttackState(AttackStates.SPAWN);
    }

    private PlayState predicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            state.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.HOLD_ON_LAST_FRAME));
        }
        switch (this.getAttackState().ordinal()) {
            case 0: {
                state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
                break;
            }
            case 1: {
                state.getController().setAnimation(RawAnimation.begin().then("spawn", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case 2: {
                state.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case 3: {
                state.getController().setAnimation(RawAnimation.begin().then("big_swipes", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case 4: {
                state.getController().setAnimation(RawAnimation.begin().then("charge", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case 5: {
                state.getController().setAnimation(RawAnimation.begin().then("aoe", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case 6: {
                state.getController().setAnimation(RawAnimation.begin().then("duplicate", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case 7: {
                state.getController().setAnimation(RawAnimation.begin().then("throw_moonlight", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case 8: {
                state.getController().setAnimation(RawAnimation.begin().then("shadow_orbs", Animation.LoopType.HOLD_ON_LAST_FRAME));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public void setCopy(boolean bl) {
        this.isCopy = bl;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("is_copy", this.isCopy);
        nbt.m_128379_("has_duplicated", this.hasDuplicated);
        nbt.m_128379_("has_health_updated", this.healthUpdated);
        if (this.ownerUuid != null) {
            nbt.m_128362_("original_shade", this.ownerUuid);
        }
    }

    @Override
    public int getXp() {
        return ConfigConstructor.frenzied_shade_xp;
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("has_duplicated")) {
            this.hasDuplicated = nbt.m_128471_("has_duplicated");
        }
        if (nbt.m_128441_("original_shade")) {
            this.ownerUuid = nbt.m_128342_("original_shade");
        }
        if (nbt.m_128441_("is_copy")) {
            this.isCopy = nbt.m_128471_("is_copy");
        }
        if (nbt.m_128441_("has_health_updated")) {
            this.healthUpdated = nbt.m_128471_("has_health_updated");
        }
    }

    @Override
    public boolean m_5825_() {
        return ConfigConstructor.frenzied_shade_is_fire_immune;
    }

    @Override
    public boolean m_21222_() {
        return ConfigConstructor.frenzied_shade_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.frenzied_shade_group_type;
    }

    @Override
    public String[] getBlacklistedStatusEffects() {
        return ConfigConstructor.frenzied_shade_status_effect_blacklist;
    }

    @Override
    public boolean m_213824_() {
        return ConfigConstructor.frenzied_shade_disables_shields;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.NIGHT_SHADE_IDLE_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.NIGHT_SHADE_DAMAGE_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.NIGHT_SHADE_DEATH_EVENT.get();
    }

    class ShadeMoveControl
    extends MoveControl {
        public ShadeMoveControl(NightShade owner) {
            super((Mob)owner);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3d = new Vec3(this.f_24975_ - NightShade.this.m_20185_(), this.f_24976_ - NightShade.this.m_20186_(), this.f_24977_ - NightShade.this.m_20189_());
                double d = vec3d.m_82553_();
                if (d < NightShade.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    NightShade.this.m_20256_(NightShade.this.m_20184_().m_82490_(0.5));
                } else {
                    NightShade.this.m_20256_(NightShade.this.m_20184_().m_82549_(vec3d.m_82490_(this.f_24978_ * 0.05 / d)));
                    if (NightShade.this.m_5448_() == null) {
                        Vec3 vec3d2 = NightShade.this.m_20184_();
                        NightShade.this.m_146922_(-((float)Mth.m_14136_((double)vec3d2.f_82479_, (double)vec3d2.f_82481_)) * 57.295776f);
                    } else {
                        double e = NightShade.this.m_5448_().m_20185_() - NightShade.this.m_20185_();
                        double f = NightShade.this.m_5448_().m_20189_() - NightShade.this.m_20189_();
                        NightShade.this.m_146922_(-((float)Mth.m_14136_((double)e, (double)f)) * 57.295776f);
                    }
                    NightShade.this.f_20883_ = NightShade.this.m_146908_();
                }
            }
        }
    }

    class Emerge
    extends Goal {
        Emerge() {
        }

        public boolean m_8036_() {
            return NightShade.this.m_5448_() == null;
        }

        public void m_8037_() {
            if (NightShade.this.m_5448_() == null && this.isInsideWall()) {
                NightShade.this.m_20334_(0.0, 0.1f, 0.0);
            }
        }

        private boolean isInsideWall() {
            float f = NightShade.this.m_6972_((Pose)Pose.STANDING).f_20377_ * 0.8f;
            AABB box = AABB.m_165882_((Vec3)NightShade.this.m_146892_(), (double)f, (double)1.0E-6, (double)f);
            return BlockPos.m_121921_((AABB)box).anyMatch(pos -> {
                BlockState blockState = NightShade.this.m_9236_().m_8055_(pos);
                return !blockState.m_60795_() && blockState.m_60828_((BlockGetter)NightShade.this.m_9236_(), pos) && Shapes.m_83157_((VoxelShape)blockState.m_60812_((BlockGetter)NightShade.this.m_9236_(), pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)box), (BooleanOp)BooleanOp.f_82689_);
            });
        }
    }

    public static enum AttackStates {
        IDLE,
        SPAWN,
        DEATH,
        BIG_SWIPES,
        GENERIC_CHARGE,
        AOE,
        DUPLICATE,
        THROW_MOONLIGHT,
        SHADOW_ORBS;

    }
}

