/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.effect;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.registries.ForgeRegistries;
import net.soulsweaponry.config.ChungusTonicWhitelist;
import net.soulsweaponry.entitydata.DespawnTimerData;
import net.soulsweaponry.registry.EffectRegistry;

public class ChungusTonic
extends MobEffect {
    public ChungusTonic() {
        super(MobEffectCategory.BENEFICIAL, 2752400);
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        Set<String> whitelistString = Set.of(ChungusTonicWhitelist.chungus_tonic_whitelist);
        List whitelist = whitelistString.stream().map(str -> {
            ResourceLocation entityId = new ResourceLocation((String)(str.contains(":") ? str : "minecraft:" + str));
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
        }).collect(Collectors.toList());
        if (!(entity instanceof Player) && DespawnTimerData.getDespawnTicks((Entity)entity) == 0 && !entity.m_9236_().f_46443_) {
            EntityType type = (EntityType)whitelist.get(entity.m_217043_().m_188503_(whitelist.size()));
            Entity randomEntity = type.m_20615_(entity.m_9236_());
            if (randomEntity != null) {
                randomEntity.m_146884_(entity.m_20182_());
                DespawnTimerData.setDespawnTicks(randomEntity, 1);
                if (randomEntity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)randomEntity;
                    living.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.CHUNGUS_TONIC_EFFECT.get(), 1000, 0));
                }
                if (randomEntity instanceof AbstractArrow) {
                    AbstractArrow projectile = (AbstractArrow)randomEntity;
                    projectile.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                }
                entity.m_9236_().m_7967_(randomEntity);
            }
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

