/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.DarkSorcerer;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entity.mobs.ReturningKnight;
import net.soulsweaponry.entity.util.RandomSummonPos;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDamageSource;

public class ReturningKnightGoal
extends Goal {
    private final ReturningKnight boss;
    private int targetNotVisibleTicks;
    private boolean hasUsedUnbreakable;
    private int unbreakableTimer;
    private int attackCooldown;
    private BlockPos targetPos;
    private boolean cordsRegistered;
    private int attackStatus;
    private int specialCooldown;
    private int summonCooldown;
    int randomAttack = 3;
    private final int numberOfAttacks = 6;

    public ReturningKnightGoal(ReturningKnight boss) {
        this.boss = boss;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.boss.m_5448_();
        return target != null && target.m_6084_() && this.boss.m_6779_(target);
    }

    public void resetAttackCooldown(float cooldownModifier) {
        this.attackCooldown = (int)Math.floor((float)ConfigConstructor.returning_knight_attack_cooldown_ticks * cooldownModifier) - this.boss.getReducedCooldownAttackers() * 2;
    }

    public void resetSummonCooldown(float cooldownModifier) {
        this.summonCooldown = (int)Math.floor((float)ConfigConstructor.returning_knight_summon_cooldown_ticks * cooldownModifier) - this.boss.getReducedCooldownAttackers() * 2;
    }

    public void resetSpecialCooldown(float cooldownModifier) {
        this.specialCooldown = (int)Math.floor((float)ConfigConstructor.returning_knight_special_cooldown_ticks * cooldownModifier) - this.boss.getReducedCooldownAttackers() * 2;
    }

    public float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.returning_knight_damage_modifier;
    }

    public void m_8041_() {
        super.m_8041_();
        this.boss.m_21561_(false);
        this.boss.setObliterate(false);
        this.boss.setBlind(false);
        this.boss.setRupture(false);
        this.boss.setSummon(false);
        this.boss.setMaceOfSpades(false);
        this.attackCooldown = 10;
        this.attackStatus = 0;
        this.cordsRegistered = false;
    }

    public void m_8037_() {
        --this.attackCooldown;
        --this.unbreakableTimer;
        --this.specialCooldown;
        --this.summonCooldown;
        LivingEntity target = this.boss.m_5448_();
        if (target != null && !this.boss.isSpawning()) {
            this.boss.m_21561_(true);
            this.boss.m_21563_().m_24946_(target.m_20185_(), target.m_20188_(), target.m_20189_());
            boolean entityInSight = this.boss.m_21574_().m_148306_((Entity)target);
            double distanceToEntity = this.boss.m_20280_((Entity)target);
            this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
            if (this.boss.m_21223_() <= this.boss.m_21233_() / 2.0f && !this.hasUsedUnbreakable && this.attackCooldown > 20) {
                this.hasUsedUnbreakable = true;
                this.unbreakableTimer = 38;
                this.boss.setUnbreakable(true);
                this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 40));
            } else if (this.unbreakableTimer == 19) {
                this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), (SoundEvent)SoundRegistry.NIGHTFALL_SHIELD_EVENT.get(), SoundSource.HOSTILE, 0.75f, 1.0f);
            }
            if (this.unbreakableTimer < 0) {
                this.boss.setUnbreakable(false);
                this.unbreakableTimer = -5;
            }
            if (this.attackCooldown < 0 && this.specialCooldown < 0 && this.summonCooldown < 0 && this.randomAttack == 3 && !this.boss.hasHealersAlive()) {
                this.boss.setSummon(true);
            }
            if (this.boss.getSummon()) {
                ++this.attackStatus;
                this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
                if (this.attackStatus == 30) {
                    int enemyNumber = this.boss.m_217043_().m_188503_(3) + 2;
                    int healerNumber = this.boss.m_217043_().m_188503_(2) + 1;
                    if (this.boss.m_21223_() <= this.boss.m_21233_() / 2.0f) {
                        enemyNumber += healerNumber;
                        healerNumber = 0;
                    }
                    Iterator remnants = new RandomSummonPos(this.boss.m_9236_(), this.boss.m_217043_(), enemyNumber, 10, this.boss.m_20183_(), 10, 8, 5, pos -> this.summonAllies((Vec3)pos, false));
                    RandomSummonPos healers = new RandomSummonPos(this.boss.m_9236_(), this.boss.m_217043_(), healerNumber, 10, this.boss.m_20183_(), 10, 8, 5, pos -> this.summonAllies((Vec3)pos, true));
                    ((RandomSummonPos)((Object)remnants)).applySummonSpawns();
                    healers.applySummonSpawns();
                    if (!this.boss.m_9236_().f_46443_) {
                        ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 300, target.m_20185_(), target.m_20186_(), target.m_20189_(), ParticleEvents.GROUND_RUPTURE_MAP, 1.0f);
                    }
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 1));
                    this.boss.m_9236_().m_5594_(null, target.m_20183_(), (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.HOSTILE, 0.7f, 1.0f);
                }
                if (this.attackStatus >= 48) {
                    this.boss.setSummon(false);
                    this.resetAttackCooldown(1.0f);
                    this.resetSummonCooldown(1.0f);
                    this.resetSpecialCooldown(1.5f);
                    this.attackStatus = 0;
                    this.randomAttack = this.boss.m_217043_().m_188503_(this.numberOfAttacks);
                }
            }
            if (this.attackCooldown < 0 && !this.cordsRegistered && distanceToEntity < 50.0 && this.randomAttack == 5 && target.m_20183_() != null) {
                this.targetPos = target.m_20183_();
                this.boss.setMaceOfSpades(true);
                this.cordsRegistered = true;
            }
            if (this.boss.getMaceOfSpades() && this.targetPos != null) {
                LivingEntity livingEntity;
                ++this.attackStatus;
                this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
                this.boss.m_21563_().m_24946_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_());
                this.boss.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), 0.0);
                AABB aoe = new AABB((double)(this.targetPos.m_123341_() - 5), (double)(this.targetPos.m_123342_() - 2), (double)(this.targetPos.m_123343_() - 5), (double)(this.targetPos.m_123341_() + 5), (double)(this.targetPos.m_123342_() + 2), (double)(this.targetPos.m_123343_() + 5));
                List entities = this.boss.m_9236_().m_45933_((Entity)this.boss, aoe);
                if (this.attackStatus == 7) {
                    for (Entity entity : entities) {
                        if (!(entity instanceof LivingEntity)) continue;
                        livingEntity = (LivingEntity)entity;
                        livingEntity.m_147240_(2.0, -(livingEntity.m_20185_() - this.boss.m_20185_()), -(livingEntity.m_20189_() - this.boss.m_20189_()));
                        livingEntity.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(20.0f));
                    }
                    this.boss.m_9236_().m_5594_(null, this.targetPos, (SoundEvent)SoundRegistry.KNIGHT_SWIPE_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                if (this.attackStatus == 13 && target.m_20183_() != null) {
                    this.targetPos = target.m_20183_();
                }
                if (this.attackStatus == 21 && this.targetPos != null) {
                    entities = this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(this.targetPos).m_82400_(3.0));
                    for (Entity entity : entities) {
                        if (!(entity instanceof LivingEntity)) continue;
                        livingEntity = (LivingEntity)entity;
                        livingEntity.m_5997_(0.0, 1.0, 0.0);
                        livingEntity.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(25.0f));
                    }
                    this.boss.m_9236_().m_5594_(null, this.targetPos, (SoundEvent)SoundRegistry.NIGHTFALL_BONK_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                    if (!this.boss.m_9236_().f_46443_) {
                        ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 300, this.targetPos.m_123341_(), this.targetPos.m_123342_(), this.targetPos.m_123343_(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                    }
                }
                if (this.attackStatus >= 36) {
                    this.boss.setMaceOfSpades(false);
                    this.resetAttackCooldown(1.0f);
                    this.cordsRegistered = false;
                    this.attackStatus = 0;
                    this.boss.m_21573_().m_26573_();
                    this.randomAttack = this.boss.m_217043_().m_188503_(this.numberOfAttacks);
                }
            }
            if (this.attackCooldown < 0 && !this.cordsRegistered && distanceToEntity < 75.0 && this.randomAttack == 0 && target.m_20183_() != null) {
                this.targetPos = target.m_20183_();
                this.boss.setObliterate(true);
                this.cordsRegistered = true;
            }
            if (this.boss.getObliterate() && this.targetPos != null) {
                ++this.attackStatus;
                this.boss.m_21563_().m_24946_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_());
                this.boss.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), 0.0);
                this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
                AABB aoe = new AABB(this.targetPos).m_82400_(3.0);
                List entities = this.boss.m_9236_().m_45933_((Entity)this.boss, aoe);
                if (this.attackStatus == 18) {
                    for (Entity entity : entities) {
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity living = (LivingEntity)entity;
                        entity.m_6469_(CustomDamageSource.create(this.boss.m_9236_(), CustomDamageSource.OBLITERATED, (Entity)this.boss), this.getModifiedDamage(60.0f));
                        entity.m_20334_(entity.m_20184_().f_82479_, 1.0, entity.m_20184_().f_82481_);
                        if (!living.m_21224_() || !this.isValidSpawn(living.m_20183_())) continue;
                        this.summonAllies(living.m_20182_(), false);
                        if (!(this.boss.m_21223_() <= this.boss.m_21233_() / 2.0f)) continue;
                        this.summonAllies(living.m_20182_(), false);
                    }
                    this.boss.m_9236_().m_5594_(null, this.targetPos, (SoundEvent)SoundRegistry.NIGHTFALL_BONK_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                    if (!this.boss.m_9236_().f_46443_) {
                        ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 300, this.targetPos.m_123341_(), this.targetPos.m_123342_(), this.targetPos.m_123343_(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                    }
                }
                if (this.attackStatus >= 32) {
                    this.boss.setObliterate(false);
                    this.resetAttackCooldown(1.0f);
                    this.cordsRegistered = false;
                    this.attackStatus = 0;
                    this.boss.m_21573_().m_26573_();
                    this.randomAttack = this.boss.m_217043_().m_188503_(this.numberOfAttacks);
                }
            }
            if (this.attackCooldown < 0 && distanceToEntity < 25.0 && this.randomAttack == 1) {
                this.boss.setBlind(true);
            }
            if (this.boss.getBlind()) {
                ++this.attackStatus;
                this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
                double x = target.m_20185_() - this.boss.m_20185_();
                double z = target.m_20189_() - this.boss.m_20189_();
                if (this.attackStatus == 12 && distanceToEntity < 25.0) {
                    target.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(10.0f));
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0));
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0));
                    target.m_147240_(2.0, -x, -z);
                    this.boss.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_144244_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    if (!this.boss.m_9236_().f_46443_) {
                        ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 150, target.m_20185_(), target.m_20188_(), target.m_20189_(), ParticleEvents.BLINDING_LIGHT_MAP, 1.0f);
                    }
                }
                if (this.attackStatus >= 19) {
                    this.boss.setBlind(false);
                    this.resetAttackCooldown(0.0f);
                    this.attackStatus = 0;
                    this.randomAttack = this.boss.m_217043_().m_188503_(this.numberOfAttacks);
                }
            }
            if (this.attackCooldown < 0 && this.specialCooldown < 0 && distanceToEntity < 300.0 && this.randomAttack == 2) {
                this.boss.setRupture(true);
            }
            if (this.boss.getRupture()) {
                ++this.attackStatus;
                this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 20));
                AABB aoe = new AABB(this.boss.m_20185_() - 18.0, this.boss.m_20186_() - 8.0, this.boss.m_20189_() - 18.0, this.boss.m_20185_() + 18.0, this.boss.m_20186_() + 8.0, this.boss.m_20189_() + 18.0);
                List entities = this.boss.m_9236_().m_45933_((Entity)this.boss, aoe);
                if (this.attackStatus == 21 || this.attackStatus == 33) {
                    for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, this.boss.m_20191_().m_82400_(12.0))) {
                        this.boss.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12599_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    }
                }
                if (this.attackStatus == 52) {
                    for (Entity entity : entities) {
                        if (!(entity instanceof LivingEntity)) continue;
                        entity.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(30.0f));
                        entity.m_20334_(entity.m_20184_().f_82479_, 1.5, entity.m_20184_().f_82481_);
                        this.boss.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
                        if (this.boss.m_9236_().f_46443_) continue;
                        ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 300, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleEvents.GROUND_RUPTURE_MAP, 1.0f);
                    }
                }
                if (this.attackStatus >= 70) {
                    this.boss.setRupture(false);
                    this.resetAttackCooldown(0.0f);
                    this.resetSpecialCooldown(1.0f);
                    this.attackStatus = 0;
                    this.randomAttack = this.boss.m_217043_().m_188503_(this.numberOfAttacks);
                }
            }
            if (this.specialCooldown > 60 && this.randomAttack == 2) {
                this.randomAttack = this.boss.m_217043_().m_188503_(this.numberOfAttacks);
            }
            if (this.specialCooldown > 100 && this.randomAttack == 3) {
                this.randomAttack = this.boss.m_217043_().m_188503_(this.numberOfAttacks);
            }
            if (this.randomAttack == 4) {
                this.randomAttack = 0;
            }
            if ((this.randomAttack == 1 && !this.boss.getBlind() || this.randomAttack == 5 && !this.boss.getMaceOfSpades() || this.randomAttack == 0 && !this.boss.getObliterate()) && this.attackCooldown < -40) {
                this.randomAttack = this.boss.m_217043_().m_188503_(this.numberOfAttacks);
            }
            if (this.targetNotVisibleTicks < 5) {
                this.boss.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
            }
            super.m_8037_();
        }
    }

    private void summonAllies(Vec3 pos, boolean healer) {
        Object entity = healer ? new DarkSorcerer((EntityType<? extends Monster>)((EntityType)EntityRegistry.DARK_SORCERER.get()), this.boss.m_9236_()) : new Remnant((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.REMNANT.get()), this.boss.m_9236_());
        entity.m_146884_(pos);
        this.boss.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        this.boss.m_9236_().m_7967_((Entity)entity);
        if (healer) {
            this.boss.addHealer(entity.m_20148_());
        }
        if (!this.boss.m_9236_().f_46443_) {
            ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 100, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), ParticleEvents.SOUL_RUPTURE_MAP, 1.0f);
        }
    }

    private boolean isValidSpawn(BlockPos pos) {
        return this.boss.m_9236_().m_8055_(pos).m_60795_() && !this.boss.m_9236_().m_8055_(pos.m_7495_()).m_60795_();
    }
}

