/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.entity.mobs.Forlorn;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entity.mobs.SoulReaperGhost;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.entity.projectile.NightSkull;
import net.soulsweaponry.entity.projectile.NightsEdge;
import net.soulsweaponry.entity.projectile.NoDragWitherSkull;
import net.soulsweaponry.entity.projectile.noclip.BlackflameExplosionEntity;
import net.soulsweaponry.entity.projectile.noclip.BlackflameSnakeEntity;
import net.soulsweaponry.entity.projectile.noclip.FogEntity;
import net.soulsweaponry.entity.projectile.noclip.NightWaveEntity;
import net.soulsweaponry.entity.projectile.noclip.NoClipEntity;
import net.soulsweaponry.entity.util.BlackflameSnakeUtil;
import net.soulsweaponry.entity.util.DeathSpiralLogic;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class NightProwlerGoal
extends MeleeAttackGoal {
    private final NightProwler boss;
    private int attackCooldown;
    private int specialCooldown;
    private int attackStatus;
    private int attackLength;
    private boolean hasExploded;
    private int changeFlightTargetTimer;
    private Vec3 flightPosAdder;
    private int bonusDmg;
    private int flipCounter;
    public static final float PORTAL_RADIUS = 16.0f;

    public NightProwlerGoal(NightProwler boss, double speed, boolean pauseWhenMobIdle) {
        super((PathfinderMob)boss, speed, pauseWhenMobIdle);
        this.boss = boss;
    }

    public boolean m_8036_() {
        if (this.boss.isFlying() && this.boss.m_5448_() != null) {
            return true;
        }
        return super.m_8036_();
    }

    public void m_8041_() {
        super.m_8041_();
        int remainingTicks = this.attackLength - this.attackStatus;
        if (remainingTicks > 0) {
            this.boss.setWaitAnimation(true);
        }
        this.boss.setRemainingAniTicks(remainingTicks);
        this.attackCooldown = 20;
        this.specialCooldown = 20;
        this.attackStatus = 0;
        this.attackLength = 0;
        this.hasExploded = false;
        this.boss.setFlying(false);
        this.changeFlightTargetTimer = 0;
        this.boss.setParticleState(0);
        this.bonusDmg = 0;
        this.flipCounter = 0;
    }

    private void checkAndSetAttack(LivingEntity target) {
        double distanceToEntity = this.boss.m_20280_((Entity)target);
        int rand = this.boss.m_217043_().m_188503_(NightProwler.ATTACKS_LENGTH);
        NightProwler.Attacks attack = NightProwler.Attacks.values()[rand];
        switch (attack) {
            case TRINITY: {
                if (!this.isInMeleeRange(target) && !this.boss.isFlying()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case REAPING_SLASH: {
                if (this.boss.isPhaseTwo() || !(distanceToEntity < 300.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case NIGHTS_EMBRACE: {
                if (!(this.boss.isPhaseTwo() ? !this.isSummonsAlive() : this.specialCooldown <= 0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case RIPPLE_FANG: 
            case SOUL_REAPER: {
                if (!this.isInMeleeRange(target)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case DARKNESS_RISE: {
                if (!this.isInMeleeRange(target) || this.boss.getDarknessRise()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case BLADES_REACH: {
                if (!(distanceToEntity < 200.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case DIMINISHING_LIGHT: 
            case ENGULF: 
            case BLACKFLAME_SNAKE: {
                this.boss.setAttackAnimation(attack);
                break;
            }
            case ECLIPSE: {
                if (!this.boss.isPhaseTwo() || this.specialCooldown > 0) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case LUNAR_DISPLACEMENT: {
                if (!this.boss.isPhaseTwo()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case DEATHBRINGERS_GRASP: {
                if (!(distanceToEntity < 81.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            default: {
                this.boss.setAttackAnimation(NightProwler.Attacks.IDLE);
            }
        }
    }

    public void m_8037_() {
        LivingEntity target;
        if (this.boss.getRemainingAniTicks() > 0 || this.boss.getAttackAnimation().equals((Object)NightProwler.Attacks.SPAWN)) {
            return;
        }
        if (this.boss.isInitiatingPhaseTwo()) {
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 255));
            return;
        }
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        this.specialCooldown = Math.max(this.specialCooldown - 1, 0);
        if (!this.boss.isFlying() && this.boss.shouldChaseTarget()) {
            super.m_8037_();
        }
        if ((target = this.boss.m_5448_()) != null) {
            if (this.boss.isFlying() && !this.boss.getAttackAnimation().equals((Object)NightProwler.Attacks.ECLIPSE)) {
                this.moveAboveTarget(target);
            }
            if (this.attackCooldown <= 0 && this.boss.getAttackAnimation().equals((Object)NightProwler.Attacks.IDLE)) {
                this.checkAndSetAttack(target);
            }
            boolean phase2 = this.boss.isPhaseTwo();
            switch (this.boss.getAttackAnimation()) {
                case TRINITY: {
                    this.attackLength = phase2 ? 90 : 110;
                    this.trinity();
                    break;
                }
                case REAPING_SLASH: {
                    this.attackLength = 70;
                    this.reapingSlash(target);
                    break;
                }
                case NIGHTS_EMBRACE: {
                    this.attackLength = phase2 ? 90 : 80;
                    this.nightsEmbrace();
                    break;
                }
                case RIPPLE_FANG: {
                    this.attackLength = phase2 ? 45 : 30;
                    this.rippleFang(target);
                    break;
                }
                case BLADES_REACH: {
                    this.attackLength = phase2 ? 60 : 40;
                    this.bladesReach(target);
                    break;
                }
                case SOUL_REAPER: {
                    this.attackLength = phase2 ? 150 : 95;
                    this.soulReaper(target);
                    break;
                }
                case DIMINISHING_LIGHT: {
                    this.attackLength = phase2 ? 60 : 40;
                    this.diminishingLight(target);
                    break;
                }
                case DARKNESS_RISE: {
                    this.attackLength = phase2 ? 70 : 40;
                    this.darknessRise();
                    break;
                }
                case ECLIPSE: {
                    this.attackLength = 270;
                    this.eclipse();
                    break;
                }
                case ENGULF: {
                    this.attackLength = phase2 ? 90 : 42;
                    this.engulf(target);
                    break;
                }
                case BLACKFLAME_SNAKE: {
                    this.attackLength = phase2 ? 140 : 60;
                    this.blackflameSnake(target);
                    break;
                }
                case LUNAR_DISPLACEMENT: {
                    this.attackLength = 70;
                    this.lunarDisplacement(target);
                    break;
                }
                case DEATHBRINGERS_GRASP: {
                    this.attackLength = phase2 ? 60 : 35;
                    this.deathsGrasp(target);
                }
            }
        }
    }

    private Vec3 randomizeVecAdder() {
        return new Vec3((double)(this.boss.m_217043_().m_216332_(3, 10) * (this.boss.m_217043_().m_188499_() ? -1 : 1)), 0.0, (double)(this.boss.m_217043_().m_216332_(3, 10) * (this.boss.m_217043_().m_188499_() ? -1 : 1)));
    }

    private void moveAboveTarget(LivingEntity target) {
        Vec3 vec3d2;
        boolean bl;
        double d;
        Vec3 vec3d;
        block9: {
            block8: {
                this.boss.m_21563_().m_148051_((Entity)target);
                this.boss.m_21391_((Entity)target, this.boss.m_21529_(), this.boss.m_8132_());
                vec3d = this.boss.m_20184_().m_82542_((double)0.8f, (double)0.6f, (double)0.8f);
                d = vec3d.f_82480_;
                bl = this.boss.getAttackAnimation().equals((Object)NightProwler.Attacks.TRINITY);
                if (this.boss.m_20186_() < target.m_20186_()) break block8;
                double d2 = this.boss.m_20186_();
                double d3 = target.m_20186_();
                float f = bl ? 9.0f : 6.0f;
                if (!(d2 < d3 + (double)f)) break block9;
            }
            d = Math.max(0.0, d);
            d += 0.3 - d * (double)0.6f;
        }
        vec3d = new Vec3(vec3d.f_82479_, d, vec3d.f_82481_);
        if (this.flightPosAdder != null) {
            ++this.changeFlightTargetTimer;
            if (this.changeFlightTargetTimer >= 40) {
                this.flightPosAdder = this.randomizeVecAdder();
                this.changeFlightTargetTimer = 0;
            }
        } else {
            this.flightPosAdder = this.randomizeVecAdder();
        }
        if ((vec3d2 = new Vec3(target.m_20185_() - this.boss.m_20185_() + (bl ? 0.0 : this.flightPosAdder.f_82479_), 0.0, target.m_20189_() - this.boss.m_20189_() + (bl ? 0.0 : this.flightPosAdder.f_82481_))).m_165925_() > 9.0) {
            Vec3 vec3d3 = vec3d2.m_82541_();
            vec3d = vec3d.m_82520_(vec3d3.f_82479_ * 0.3 - vec3d.f_82479_ * 0.6, 0.0, vec3d3.f_82481_ * 0.3 - vec3d.f_82481_ * 0.6);
        }
        this.boss.m_20256_(vec3d);
    }

    private void checkAndReset(int attackCooldown, int specialCooldown) {
        if (this.attackStatus > this.attackLength) {
            this.attackStatus = 0;
            this.attackCooldown = Mth.m_14107_((double)((double)attackCooldown * (this.boss.isPhaseTwo() ? ConfigConstructor.night_prowler_cooldown_modifier_phase_2 : ConfigConstructor.night_prowler_cooldown_modifier_phase_1)));
            if (specialCooldown != 0) {
                this.specialCooldown = Mth.m_14107_((double)((double)specialCooldown * (this.boss.isPhaseTwo() ? ConfigConstructor.night_prowler_special_cooldown_modifier_phase_2 : ConfigConstructor.night_prowler_special_cooldown_modifier_phase_1)));
            }
            this.attackLength = 0;
            this.boss.setAttackAnimation(NightProwler.Attacks.IDLE);
            this.boss.setChaseTarget(true);
            this.hasExploded = false;
            this.boss.setParticleState(0);
            this.bonusDmg = 0;
            this.flipCounter = 0;
            if (this.boss.isPhaseTwo()) {
                this.boss.setFlying(false);
            }
        }
    }

    private float getModifiedDamage(float damage) {
        return (damage + (float)this.bonusDmg) * ConfigConstructor.night_prowler_damage_modifier * (this.boss.isEmpowered() ? 1.25f : 1.0f) * (this.boss.getDarknessRise() ? 1.25f : 1.0f);
    }

    private boolean damageTarget(LivingEntity target, float damage) {
        if (this.boss.isPartner(target)) {
            return false;
        }
        if (target.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(damage))) {
            if (this.boss.isEmpowered()) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0));
                if (target.m_21224_()) {
                    this.boss.m_5634_(target.m_21233_());
                }
            }
            return true;
        }
        return false;
    }

    protected void m_6739_(LivingEntity target, double squaredDistance) {
    }

    protected boolean isInMeleeRange(LivingEntity target) {
        double distanceToEntity = this.boss.m_20280_((Entity)target);
        return distanceToEntity <= this.m_6639_(target);
    }

    private void playSound(@Nullable BlockPos pos, SoundEvent sound, float volume, float pitch) {
        if (pos == null) {
            pos = this.boss.m_20183_();
        }
        this.boss.m_9236_().m_5594_(null, pos, sound, SoundSource.HOSTILE, volume, pitch);
    }

    private void trinity() {
        DayStalker partner;
        boolean bl2;
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        boolean phase2 = this.boss.isPhaseTwo();
        int stopFlying = phase2 ? 61 : 75;
        int min = phase2 ? 65 : 77;
        int max = phase2 ? 76 : 95;
        boolean bl1 = this.attackStatus >= (phase2 ? 16 : 26) && this.attackStatus <= (phase2 ? 60 : 68);
        boolean bl = this.attackStatus >= (phase2 ? 38 : 45) && this.attackStatus <= (phase2 ? 43 : 51) ? true : (bl2 = false);
        if (bl1 && this.attackStatus % 3 == 0 && !bl2) {
            this.boss.m_5496_((SoundEvent)SoundRegistry.SCYTHE_SWIPE.get(), 1.0f, (float)this.boss.m_217043_().m_216332_(6, 10) / 10.0f);
        }
        if (phase2 && this.attackStatus == 5) {
            this.boss.m_5496_(SoundEvents.f_12558_, 1.0f, 1.0f);
            this.boss.setFlying(true);
            this.boss.m_5997_(0.0, 0.75, 0.0);
        }
        if (this.boss.isFlying() && this.attackStatus == stopFlying && !this.boss.m_9236_().f_46443_ && (partner = this.boss.getPartner((ServerLevel)this.boss.m_9236_())) != null) {
            this.boss.setFlying(false);
            partner.setFlying(true);
            partner.flightTimer = ConfigConstructor.duo_fight_time_before_switch;
            this.boss.m_20334_(0.0, -2.0, 0.0);
        }
        if (!this.hasExploded && this.attackStatus >= min && this.attackStatus <= max && this.boss.m_20096_()) {
            Vec3 vec = this.boss.m_20154_().m_82490_(4.0).m_82549_(this.boss.m_20182_());
            BlockPos pos = new BlockPos((int)vec.m_7096_(), this.boss.m_146904_(), (int)vec.m_7094_());
            AABB box = new AABB(pos).m_82400_(3.0);
            this.aoe(box, 40.0f, 3.0f, true);
            this.hasExploded = true;
            this.boss.setTargetPos(pos);
            this.boss.setParticleState(1);
            Vec3 target = Vec3.m_82512_((Vec3i)pos);
            ParticleHandler.flashParticle(this.boss.m_9236_(), target.m_7096_(), target.m_7098_(), target.m_7094_(), new ParticleHandler.RGB(142.0f, 107.0f, 1.0f), 10.0f);
            ParticleHandler.flashParticle(this.boss.m_9236_(), target.m_7096_(), target.m_7098_(), target.m_7094_(), new ParticleHandler.RGB(72.0f, 0.0f, 140.0f), 2.0f);
            ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 300, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), ParticleEvents.OBLITERATE_MAP, 1.0f);
            this.boss.m_5496_((SoundEvent)SoundRegistry.TRINITY.get(), 1.0f, 1.0f);
            if (this.boss.isPhaseTwo()) {
                this.trinityShockwave();
            }
        } else {
            this.boss.setParticleState(0);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 40 : 60, 0);
    }

    private void trinityShockwave() {
        float r = 1.0f;
        for (int theta = 0; theta < 360; theta += 15) {
            double x0 = this.boss.m_20185_();
            double z0 = this.boss.m_20189_();
            double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
            double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
            NightWaveEntity wave = new NightWaveEntity((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.NIGHT_WAVE.get()), this.boss.m_9236_());
            wave.m_20343_(x, this.boss.m_20186_(), z);
            wave.m_37251_((Entity)this.boss, 0.0f, theta - 90, 0.0f, 1.5f, 0.0f);
            wave.m_36781_(this.getModifiedDamage(20.0f));
            wave.m_5602_((Entity)this.boss);
            this.boss.m_9236_().m_7967_((Entity)wave);
        }
    }

    public void aoe(AABB box, float damage, float knockback, boolean knockbackAway, MobEffect[] effects) {
        for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, box)) {
            LivingEntity target;
            if (!(entity instanceof LivingEntity) || !this.damageTarget(target = (LivingEntity)entity, damage) || !(knockback > 0.0f)) continue;
            double x = target.m_20185_() - this.boss.m_20185_();
            double z = target.m_20189_() - this.boss.m_20189_();
            int mod = knockbackAway ? 1 : -1;
            target.m_147240_((double)knockback, -x * (double)mod, -z * (double)mod);
            for (MobEffect effect : effects) {
                target.m_7292_(new MobEffectInstance(effect, 60, 0));
            }
        }
    }

    public void aoe(AABB box, float damage, float knockback, boolean knockbackAway) {
        this.aoe(box, damage, knockback, knockbackAway, new MobEffect[0]);
    }

    private void reapingSlash(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        double x = (target.m_20185_() - this.boss.m_20185_()) / 10.0;
        double y = (target.m_20186_() - this.boss.m_20186_()) / 10.0;
        double z = (target.m_20189_() - this.boss.m_20189_()) / 10.0;
        if (this.attackStatus >= 26 && this.attackStatus <= 40) {
            this.boss.m_20334_(x, y, z);
            if (this.attackStatus % 2 == 0) {
                this.aoe(this.boss.m_20191_().m_82400_(2.0), 25.0f, 0.0f, true);
            }
        }
        this.checkAndReset(5, 0);
    }

    private void nightsEmbrace() {
        boolean bl1;
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        boolean phase2 = this.boss.isPhaseTwo();
        int trigger = phase2 ? 75 : 61;
        boolean bl = this.attackStatus >= (phase2 ? 18 : 13) && this.attackStatus <= (phase2 ? 46 : 56) ? true : (bl1 = false);
        if (bl1 && this.attackStatus % 3 == 0) {
            this.boss.m_5496_((SoundEvent)SoundRegistry.SCYTHE_SWIPE.get(), 1.0f, (float)this.boss.m_217043_().m_216332_(6, 10) / 10.0f);
        }
        if (!this.boss.m_9236_().f_46443_ && this.attackStatus == trigger) {
            DayStalker partner = phase2 ? null : this.boss.getPartner((ServerLevel)this.boss.m_9236_());
            BlockPos start = partner == null || partner.isFlying() ? this.boss.m_20183_() : partner.m_20183_();
            int amount = phase2 ? 4 : 8;
            int[] list = new int[amount];
            int i = 0;
            for (int theta = 0; theta < 360; theta += 360 / amount) {
                Remnant entity;
                int r = 5;
                double x0 = start.m_123341_();
                double z0 = start.m_123343_();
                double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
                double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
                BlockPos pos = BlockPos.m_274561_((double)x, (double)(start.m_123342_() - 3), (double)z);
                if (phase2) {
                    entity = new Forlorn((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.FORLORN.get()), this.boss.m_9236_());
                    HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
                    map.put(Enchantments.f_44965_, 2);
                    map.put(Enchantments.f_44963_, 1);
                    Forlorn.initEquip((LivingEntity)entity, map);
                } else {
                    entity = new SoulReaperGhost((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.SOUL_REAPER_GHOST.get()), this.boss.m_9236_());
                }
                pos = this.getNonAirPos(pos, this.boss.m_9236_());
                entity.m_20343_(pos.m_123341_(), (float)pos.m_123342_() + 0.1f, pos.m_123343_());
                ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 100, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), ParticleEvents.CONJURE_ENTITY_MAP, 1.0f);
                DeathSpiralEntity spiral = new DeathSpiralEntity(this.boss.m_9236_(), entity.m_20182_(), 1.0f);
                spiral.m_146884_(entity.m_20182_());
                this.boss.m_9236_().m_7967_((Entity)spiral);
                this.playSound(pos, (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), 0.7f, 1.0f);
                this.boss.m_9236_().m_7967_((Entity)entity);
                list[i] = entity.m_19879_();
                ++i;
            }
            this.boss.setAliveSummons(list);
            this.boss.m_5496_((SoundEvent)SoundRegistry.SCYTHE_SWIPE.get(), 1.0f, 0.75f);
        }
        this.checkAndReset(phase2 ? 10 : 60, phase2 ? 120 : 200);
    }

    private BlockPos getNonAirPos(BlockPos start, Level world) {
        if (!world.m_8055_(start).m_280555_() && !world.m_8055_(start.m_7494_()).m_280555_()) {
            return start;
        }
        return this.getNonAirPos(start.m_7918_(0, 1, 0), world);
    }

    private boolean isSummonsAlive() {
        int i;
        int[] list = this.boss.getAliveSummonsList();
        int[] arr = new int[list.length];
        for (i = 0; i < list.length; ++i) {
            if (this.boss.m_9236_().m_6815_(list[i]) == null) continue;
            arr[i] = list[i];
        }
        this.boss.setAliveSummons(arr);
        i = 0;
        for (int d : arr) {
            i += d;
        }
        return i != 0;
    }

    private void rippleFang(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        boolean phase2 = this.boss.isPhaseTwo();
        if (this.attackStatus == 1) {
            this.boss.m_5496_((SoundEvent)SoundRegistry.NIGHT_SKULL_DIE.get(), 1.0f, 0.75f);
        }
        if (this.attackStatus == (phase2 ? 29 : 18)) {
            float yawRad = (float)Mth.m_14136_((double)(target.m_20189_() - this.boss.m_20189_()), (double)(target.m_20185_() - this.boss.m_20185_()));
            float yawDeg = (float)Math.toDegrees(yawRad);
            double heightDiff = Math.abs(target.m_20186_() - this.boss.m_20186_());
            double maxYOffset = heightDiff + 2.0;
            WeaponUtil.doConsumerOnCircle(this.boss.m_9236_(), yawDeg, this.boss.m_20182_(), maxYOffset, 5, new Vec2(1.5f, 1.75f), (TriConsumer<Vec3, Integer, Float>)((TriConsumer)this::spawnNightsEdge));
        }
        this.checkAndReset(5, 0);
    }

    private void spawnNightsEdge(Vec3 position, Integer warmup, Float yaw) {
        if (this.boss.isPhaseTwo()) {
            NightsEdge edge = new NightsEdge((EntityType<? extends NightsEdge>)((EntityType)EntityRegistry.NIGHTS_EDGE.get()), this.boss.m_9236_());
            edge.setOwner((LivingEntity)this.boss);
            edge.setWarmup(warmup);
            edge.setDamage(this.getModifiedDamage(15.69f));
            edge.m_146922_(yaw.floatValue());
            edge.m_20343_(position.f_82479_, position.f_82480_, position.f_82481_);
            this.boss.m_9236_().m_7967_((Entity)edge);
        } else {
            this.boss.m_9236_().m_7967_((Entity)new EvokerFangs(this.boss.m_9236_(), position.f_82479_, position.f_82480_, position.f_82481_, yaw.floatValue(), warmup.intValue(), (LivingEntity)this.boss));
        }
    }

    private void bladesReach(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        boolean phase2 = this.boss.isPhaseTwo();
        if (this.attackStatus == (phase2 ? 16 : 23)) {
            WeaponUtil.doConsumerOnLine(this.boss.m_9236_(), (float)Math.toDegrees((float)Mth.m_14136_((double)(target.m_20189_() - this.boss.m_20189_()), (double)(target.m_20185_() - this.boss.m_20185_()))), this.boss.m_20182_(), 10.0, 20, 1.25f, (TriConsumer<Vec3, Integer, Float>)((TriConsumer)this::spawnNightsEdge));
            this.boss.m_5496_((SoundEvent)SoundRegistry.SCYTHE_SWIPE.get(), 1.0f, 0.7f);
        }
        if (phase2 && this.attackStatus == 43) {
            Vec3 vec = new Vec3(target.m_20185_() - this.boss.m_20185_(), target.m_20188_() - this.boss.m_20227_(1.0), target.m_20189_() - this.boss.m_20189_());
            this.shootSplitSkulls(vec, 5, 1.75f);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 1 : 40, 0);
    }

    private void shootSplitSkulls(Vec3 target, int amount, float velocity) {
        this.shootSplitProjectile(target, amount, velocity, (EntityType<? extends Projectile>)((EntityType)EntityRegistry.NO_DRAG_WITHER_SKULL.get()));
    }

    private void shootSplitProjectile(Vec3 target, int amount, float velocity, EntityType<? extends Projectile> type) {
        int m = Mth.m_14143_((float)((float)amount / 2.0f));
        this.playSound(null, SoundEvents.f_12558_, 1.0f, 1.0f);
        for (int i = -m; i <= m; ++i) {
            Vec3 vec = target.m_82524_((float)Math.toRadians(5 * i));
            Projectile entity = (Projectile)type.m_20615_(this.boss.m_9236_());
            if (entity == null) continue;
            entity.m_20343_(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_());
            entity.m_6686_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), velocity, 1.0f);
            entity.m_5602_((Entity)this.boss);
            this.boss.m_9236_().m_7967_((Entity)entity);
        }
    }

    private void shootSplitMoonlight(Vec3 target, int amount) {
        int m = Mth.m_14143_((float)((float)amount / 2.0f));
        this.playSound(null, (SoundEvent)SoundRegistry.MOONLIGHT_BIG_EVENT.get(), 1.0f, 1.0f);
        for (int i = -m; i <= m; ++i) {
            Vec3 vec = target.m_82524_((float)Math.toRadians(8 * i));
            MoonlightProjectile entity = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE.get()), this.boss.m_9236_());
            entity.setAgeAndPoints(30, 150, 4);
            entity.m_36781_(this.getModifiedDamage(20.0f));
            entity.m_20343_(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_());
            entity.m_6686_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 1.75f, 1.0f);
            entity.m_5602_((Entity)this.boss);
            this.boss.m_9236_().m_7967_((Entity)entity);
        }
    }

    private void shootSplitBoth(Vec3 target, int amount) {
        int m = Mth.m_14143_((float)((float)amount / 2.0f));
        this.playSound(null, (SoundEvent)SoundRegistry.MOONLIGHT_BIG_EVENT.get(), 1.0f, 1.0f);
        this.playSound(null, SoundEvents.f_12558_, 1.0f, 1.0f);
        for (int i = -m; i <= m; ++i) {
            Object entity;
            boolean bl;
            Vec3 vec = target.m_82524_((float)Math.toRadians(8 * i));
            boolean bl2 = bl = this.flipCounter % 2 == 0 == (i % 2 == 0);
            if (bl) {
                entity = new NoDragWitherSkull((EntityType<? extends WitherSkull>)EntityType.f_20498_, this.boss.m_9236_());
            } else {
                entity = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE.get()), this.boss.m_9236_());
                ((MoonlightProjectile)((Object)entity)).setAgeAndPoints(30, 150, 4);
                ((MoonlightProjectile)((Object)entity)).m_36781_(this.getModifiedDamage(20.0f));
            }
            entity.m_20343_(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_());
            entity.m_6686_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 1.75f, 1.0f);
            entity.m_5602_((Entity)this.boss);
            this.boss.m_9236_().m_7967_((Entity)entity);
        }
        ++this.flipCounter;
    }

    private void soulReaper(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21563_().m_148051_((Entity)target);
        this.boss.m_21391_((Entity)target, this.boss.m_21529_(), this.boss.m_8132_());
        this.boss.m_21573_().m_26573_();
        Vec3 vel = new Vec3(target.m_20185_() - this.boss.m_20185_(), target.m_20188_() - this.boss.m_20227_(1.0), target.m_20189_() - this.boss.m_20189_());
        boolean phase2 = this.boss.isPhaseTwo();
        Vec3 vec = this.boss.m_20154_().m_82490_(4.0).m_82549_(this.boss.m_20182_());
        vec = new Vec3(vec.m_7096_(), target.m_20186_(), vec.m_7094_());
        this.boss.setTargetPos(BlockPos.m_274446_((Position)vec).m_175288_(this.boss.m_146904_()));
        HashMap<Integer, AABB> map = new HashMap<Integer, AABB>();
        if (!phase2) {
            map.put(14, new AABB(BlockPos.m_274446_((Position)vec)).m_82400_(2.0));
            map.put(29, new AABB(BlockPos.m_274446_((Position)vec)).m_82400_(2.0));
            map.put(49, this.boss.m_20191_().m_82400_(2.0));
            map.put(72, this.boss.m_20191_().m_82400_(2.0));
        } else {
            map.put(17, new AABB(BlockPos.m_274446_((Position)vec)).m_82400_(2.0));
            map.put(28, new AABB(BlockPos.m_274446_((Position)vec)).m_82400_(2.0));
            map.put(50, this.boss.m_20191_().m_82400_(2.0));
            map.put(61, new AABB(BlockPos.m_274446_((Position)vec)).m_82400_(2.0));
            map.put(74, new AABB(BlockPos.m_274446_((Position)vec)).m_82400_(2.0));
            map.put(96, this.boss.m_20191_().m_82400_(2.0));
            map.put(109, new AABB(BlockPos.m_274446_((Position)vec)).m_82400_(2.0));
            map.put(128, new AABB(BlockPos.m_274446_((Position)vec)).m_82400_(3.0));
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int frame = (Integer)iterator.next();
            if (this.attackStatus != frame) continue;
            this.playSound(null, (SoundEvent)SoundRegistry.SCYTHE_SWIPE.get(), 1.0f, (float)this.boss.m_217043_().m_216332_(6, 10) / 10.0f);
            this.aoe((AABB)map.get(frame), 20.0f, 0.4f, true);
            this.bonusDmg += phase2 ? 3 : 5;
            this.boss.m_20256_(vel.m_82490_(0.1));
            if (this.attackStatus == 61) {
                this.shootSplitSkulls(vel, 3, 1.5f);
            }
            if (this.attackStatus == 74) {
                this.boss.setParticleState(2);
                this.boss.m_5496_(SoundEvents.f_12601_, 1.0f, 1.0f);
            }
            if (this.attackStatus == 109) {
                this.shootSplitMoonlight(vel, 3);
            }
            if (this.attackStatus != 128) continue;
            this.boss.setParticleState(3);
        }
        if (this.attackStatus != 74 && this.attackStatus != 128) {
            this.boss.setParticleState(0);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 5 : 40, 0);
    }

    private void diminishingLight(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21563_().m_148051_((Entity)target);
        this.boss.m_21391_((Entity)target, this.boss.m_21529_(), this.boss.m_8132_());
        this.boss.m_21573_().m_26573_();
        boolean phase2 = this.boss.isPhaseTwo();
        int[] frames = new int[]{20, 30, 40};
        Vec3 vec = new Vec3(target.m_20185_() - this.boss.m_20185_(), target.m_20188_() - this.boss.m_20227_(1.0), target.m_20189_() - this.boss.m_20189_());
        if (!phase2) {
            if (this.attackStatus == 25) {
                this.shootSplitMoonlight(vec, 5);
            }
        } else {
            for (int f : frames) {
                if (f != this.attackStatus) continue;
                this.shootSplitBoth(vec, 5);
            }
        }
        this.checkAndReset(this.boss.isFlying() ? 40 : 5, 0);
    }

    private void darknessRise() {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        if (this.attackStatus == 24) {
            this.boss.m_5496_((SoundEvent)SoundRegistry.DARKNESS_RISE.get(), 1.0f, 1.0f);
            this.boss.setDarknessRise(true);
        }
        this.checkAndReset(10, 0);
    }

    private void eclipse() {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        if (this.attackStatus <= 1) {
            this.boss.m_5496_((SoundEvent)SoundRegistry.PARTNER_DIES.get(), 0.8f, 0.8f);
            this.playSound(this.boss.m_5448_() != null ? this.boss.m_5448_().m_20183_() : this.boss.m_20183_(), (SoundEvent)SoundRegistry.PARTNER_DIES.get(), 0.8f, 0.8f);
            this.boss.setFlying(true);
            this.boss.m_5997_(0.0, 0.5, 0.0);
        }
        if (this.attackStatus == 40) {
            this.boss.setParticleState(4);
        }
        if (this.attackStatus >= 50 && this.attackStatus <= 220) {
            for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, this.boss.m_20191_().m_82400_(35.0))) {
                if (this.attackStatus % 6 != 0 || !(entity instanceof LivingEntity)) continue;
                LivingEntity target = (LivingEntity)entity;
                int radius = 10;
                Vec3 spawn = new Vec3(this.boss.m_20185_() + (double)this.boss.m_217043_().m_216332_(-radius, radius), this.boss.m_20186_() + 8.0, this.boss.m_20189_() + (double)this.boss.m_217043_().m_216332_(-radius, radius));
                Vec3 vec = new Vec3(target.m_20185_() - spawn.m_7096_(), target.m_20188_() - spawn.m_7098_(), target.m_20189_() - spawn.m_7094_());
                NightSkull skull = new NightSkull((EntityType<? extends NightSkull>)((EntityType)EntityRegistry.NIGHT_SKULL.get()), this.boss.m_9236_());
                skull.m_146884_(spawn);
                skull.m_6686_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 1.75f, 1.0f);
                skull.m_5602_((Entity)this.boss);
                this.boss.m_9236_().m_7967_((Entity)skull);
                if (!target.m_21224_() || target.f_20919_ >= 2) continue;
                this.boss.m_5634_(ConfigConstructor.night_prowler_eclipse_healing);
                DeathSpiralEntity spiral = new DeathSpiralEntity(this.boss.m_9236_(), target.m_20182_(), 1.0f);
                spiral.m_146884_(target.m_20182_());
                this.boss.m_9236_().m_7967_((Entity)spiral);
            }
        }
        if (this.attackStatus >= 240) {
            this.boss.setParticleState(0);
            this.boss.setFlying(false);
        }
        this.checkAndReset(20, 300);
    }

    private void engulf(LivingEntity target) {
        Vec3 vec;
        ++this.attackStatus;
        this.boss.m_21563_().m_148051_((Entity)target);
        this.boss.m_21391_((Entity)target, this.boss.m_21529_(), this.boss.m_8132_());
        this.boss.m_21573_().m_26573_();
        boolean phase2 = this.boss.isPhaseTwo();
        if (this.attackStatus == (phase2 ? 19 : 21)) {
            vec = new Vec3(target.m_20185_() - this.boss.m_20185_(), target.m_20186_() - this.boss.m_20186_(), target.m_20189_() - this.boss.m_20189_());
            FogEntity entity = new FogEntity((EntityType<? extends FogEntity>)((EntityType)EntityRegistry.FOG_ENTITY.get()), this.boss.m_9236_());
            entity.m_20343_(this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_());
            entity.m_6686_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 1.0f, 1.0f);
            entity.m_5602_((Entity)this.boss);
            this.boss.m_9236_().m_7967_((Entity)entity);
            this.boss.m_5496_(SoundEvents.f_12558_, 1.0f, 1.0f);
        }
        if (phase2 && this.attackStatus == 45) {
            vec = target.m_20154_().m_82490_(-3.0).m_82549_(target.m_20182_());
            this.boss.teleportTo(vec.m_7096_(), target.m_20186_(), vec.m_7094_());
            this.boss.m_21391_((Entity)target, 180.0f, 180.0f);
        }
        if (this.attackStatus == 54) {
            vec = this.boss.m_20154_().m_82490_(4.0).m_82549_(this.boss.m_20182_());
            vec = new Vec3(vec.m_7096_(), this.boss.m_20186_(), vec.m_7094_());
            this.boss.setTargetPos(BlockPos.m_274446_((Position)vec));
            this.aoe(new AABB(BlockPos.m_274446_((Position)vec)).m_82400_(2.0), 30.0f, 1.5f, true);
            this.boss.setParticleState(2);
            this.boss.m_5496_(SoundEvents.f_12601_, 1.0f, 1.0f);
        } else {
            this.boss.setParticleState(0);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 50, 0);
    }

    /*
     * WARNING - void declaration
     */
    private void blackflameSnake(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        this.boss.m_21563_().m_148051_((Entity)target);
        this.boss.m_21391_((Entity)target, this.boss.m_21529_() * 2, this.boss.m_8132_() * 2);
        boolean phase2 = this.boss.isPhaseTwo();
        if (!phase2 && this.attackStatus == 31) {
            void var5_9;
            Object vel;
            DayStalker partner;
            this.boss.m_5496_((SoundEvent)SoundRegistry.NIGHT_SKULL_DIE.get(), 1.0f, 0.75f);
            BlackflameSnakeEntity entity = new BlackflameSnakeEntity((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.BLACKFLAME_SNAKE_ENTITY.get()), this.boss.m_9236_());
            entity.m_36781_(this.getModifiedDamage(30.0f));
            if (this.boss.isFlying() && (partner = this.boss.getPartner((ServerLevel)this.boss.m_9236_())) != null) {
                vel = new Vec3(target.m_20185_() - partner.m_20185_(), target.m_20186_() - partner.m_20186_(), target.m_20189_() - partner.m_20189_()).m_82490_((double)0.2f);
                Vec3 vec3 = partner.m_20182_();
                entity.m_5602_((Entity)partner);
            } else {
                vel = new Vec3(target.m_20185_() - this.boss.m_20185_(), target.m_20186_() - this.boss.m_20186_(), target.m_20189_() - this.boss.m_20189_()).m_82490_((double)0.2f);
                Vec3 vec3 = this.boss.m_20182_();
                entity.m_5602_((Entity)this.boss);
            }
            entity.m_146884_((Vec3)var5_9);
            entity.m_20256_((Vec3)vel);
            entity.setTargetUuid(target.m_20148_());
            this.boss.m_9236_().m_7967_((Entity)entity);
        }
        if (phase2) {
            if (this.attackStatus <= 1) {
                this.boss.m_5496_((SoundEvent)SoundRegistry.NIGHT_SKULL_DIE.get(), 1.0f, 0.75f);
                this.boss.setFlying(true);
                this.boss.m_5997_(0.0, 0.5, 0.0);
            }
            if (this.attackStatus == 84) {
                this.boss.setFlying(false);
                this.boss.m_20334_(0.0, -1.0, 0.0);
            }
            if (this.attackStatus >= 84) {
                this.boss.setFlying(false);
            }
            if (!this.hasExploded && this.boss.m_20096_() && this.attackStatus >= 88 && this.attackStatus <= 110) {
                this.hasExploded = true;
                this.boss.setTargetPos(this.boss.m_20183_());
                this.boss.setParticleState(2);
                this.aoe(this.boss.m_20191_().m_82400_(2.0), 35.0f, 2.0f, true);
                List<List<Vec3>> positions = BlackflameSnakeUtil.getCurvedPositions(this.boss.m_146908_(), 10.0f, this.boss.m_20182_(), target.m_20182_());
                for (List list : positions) {
                    for (int i = 0; i < list.size(); ++i) {
                        BlackflameExplosionEntity entity = new BlackflameExplosionEntity(this.boss.m_9236_());
                        entity.m_5602_((Entity)this.boss);
                        entity.setRadius(2.0f);
                        entity.m_36781_(this.getModifiedDamage(35.0f));
                        entity.setWarmup(i);
                        entity.m_146884_((Vec3)list.get(i));
                        this.boss.m_9236_().m_7967_((Entity)entity);
                    }
                }
                BlackflameSnakeEntity entity = new BlackflameSnakeEntity(this.boss.m_9236_());
                entity.m_146884_(this.boss.m_20182_());
                entity.m_36781_(this.getModifiedDamage(30.0f));
                entity.m_20256_(new Vec3(target.m_20185_() - this.boss.m_20185_(), target.m_20186_() - this.boss.m_20186_(), target.m_20189_() - this.boss.m_20189_()).m_82490_((double)0.2f));
                entity.setTargetUuid(target.m_20148_());
                this.boss.m_9236_().m_7967_((Entity)entity);
            } else {
                this.boss.setParticleState(0);
            }
        }
        this.checkAndReset(this.boss.isFlying() ? 60 : (this.boss.isPhaseTwo() ? 5 : 30), 0);
    }

    private void lunarDisplacement(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21563_().m_148051_((Entity)target);
        this.boss.m_21391_((Entity)target, this.boss.m_21529_(), this.boss.m_8132_());
        this.boss.m_21573_().m_26573_();
        if (this.attackStatus == 1) {
            this.playSound(target.m_20183_(), (SoundEvent)SoundRegistry.NIGHT_PROWLER_SCREAM.get(), 1.0f, 1.0f);
        }
        if (this.attackStatus == 35) {
            Vec3 vec = target.m_20154_().m_82490_(-2.0).m_82549_(target.m_20182_());
            this.boss.teleportTo(vec.m_7096_(), target.m_20186_(), vec.m_7094_());
            this.boss.m_21391_((Entity)target, 180.0f, 180.0f);
        }
        if (this.attackStatus == 42) {
            this.aoe(this.boss.m_20191_().m_82400_(3.0), 35.0f, 2.0f, true);
            ParticleHandler.particleSphereList(this.boss.m_9236_(), 1000, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 1.0f, new ParticleOptions[]{ParticleTypes.f_123745_, ParticleTypes.f_123755_});
            this.boss.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f);
            this.boss.m_5496_(SoundEvents.f_11913_, 1.0f, 0.7f);
        }
        this.checkAndReset(10, 0);
    }

    private void deathsGrasp(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21563_().m_148051_((Entity)target);
        this.boss.m_21391_((Entity)target, this.boss.m_21529_(), this.boss.m_8132_());
        this.boss.m_21573_().m_26573_();
        boolean phase2 = this.boss.isPhaseTwo();
        if (this.attackStatus == (phase2 ? 18 : 23)) {
            MobEffect[] mobEffectArray;
            Vec3 out = this.boss.m_20154_().m_82542_(5.5, 0.0, 5.5).m_82520_(this.boss.m_20182_().m_7096_(), target.m_20186_(), this.boss.m_20182_().m_7094_());
            AABB box = new AABB(BlockPos.m_274446_((Position)out)).m_82400_(3.0);
            if (phase2) {
                MobEffect[] mobEffectArray2 = new MobEffect[1];
                mobEffectArray = mobEffectArray2;
                mobEffectArray2[0] = MobEffects.f_19610_;
            } else {
                mobEffectArray = new MobEffect[]{};
            }
            this.aoe(box, 10.0f, 1.0f, false, mobEffectArray);
            this.boss.m_5496_((SoundEvent)SoundRegistry.SCYTHE_SWIPE.get(), 1.0f, 0.75f);
            if (phase2 && this.boss.teleportAway()) {
                this.boss.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
        if (phase2 && this.attackStatus == 43) {
            Vec3 vec = new Vec3(target.m_20185_() - this.boss.m_20185_(), target.m_20188_() - this.boss.m_20227_(1.0), target.m_20189_() - this.boss.m_20189_());
            this.shootSplitSkulls(vec, 3, 1.75f);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 1 : 10, 0);
    }

    public static class DeathSpiralEntity
    extends NoClipEntity {
        private DeathSpiralLogic logic = new DeathSpiralLogic(this.m_20182_(), 1.0f);

        public DeathSpiralEntity(EntityType<? extends NoClipEntity> entityType, Level world) {
            super(entityType, world);
        }

        protected DeathSpiralEntity(Level world, Vec3 pos, float radius) {
            super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.DEATH_SPIRAL_ENTITY.get()), world);
            this.logic = new DeathSpiralLogic(pos, radius);
        }

        public boolean m_6469_(DamageSource source, float amount) {
            return false;
        }

        public void m_8119_() {
            super.m_8119_();
            this.m_146884_(this.m_20182_());
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 4; ++i) {
                    this.logic.tick(this.m_9236_(), this.m_20182_());
                }
            }
            if (this.logic.isFinished() || this.f_19797_ > 200) {
                this.m_146870_();
            }
        }
    }
}

