/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.registry;

import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.soulsweaponry.items.BossCompass;
import net.soulsweaponry.items.IChargeNeeded;
import net.soulsweaponry.items.IShootModProjectile;
import net.soulsweaponry.items.TranslucentWeapon;
import net.soulsweaponry.items.sword.Skofnung;
import net.soulsweaponry.items.sword.Sting;
import net.soulsweaponry.registry.GunRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.WeaponUtil;

public class PredicateRegistry {
    public static void register() {
        PredicateRegistry.registerPullAndPulling((Item)WeaponRegistry.GALEFORCE.get());
        PredicateRegistry.registerPullAndPulling((Item)WeaponRegistry.KRAKEN_SLAYER.get());
        PredicateRegistry.registerPullAndPulling((Item)WeaponRegistry.KRAKEN_SLAYER_CROSSBOW.get());
        PredicateRegistry.registerCrossbowCharged((Item)WeaponRegistry.KRAKEN_SLAYER_CROSSBOW.get());
        PredicateRegistry.registerPullAndPulling((Item)WeaponRegistry.DARKMOON_LONGBOW.get());
        PredicateRegistry.registerThrowing((Item)WeaponRegistry.COMET_SPEAR.get());
        PredicateRegistry.registerThrowing((Item)WeaponRegistry.NIGHTFALL.get());
        PredicateRegistry.registerThrowing((Item)WeaponRegistry.DARKIN_BLADE.get());
        PredicateRegistry.registerThrowing((Item)WeaponRegistry.DRAGONSLAYER_SWORDSPEAR.get());
        PredicateRegistry.registerThrowing((Item)WeaponRegistry.WHIRLIGIG_SAWBLADE.get());
        PredicateRegistry.registerThrowing((Item)GunRegistry.GATLING_GUN.get());
        PredicateRegistry.registerThrowing((Item)WeaponRegistry.LEVIATHAN_AXE.get());
        PredicateRegistry.registerThrowing((Item)WeaponRegistry.MJOLNIR.get());
        PredicateRegistry.registerThrowing((Item)WeaponRegistry.MOONLIGHT_GREATSWORD.get());
        PredicateRegistry.registerThrowing((Item)WeaponRegistry.PURE_MOONLIGHT_GREATSWORD.get());
        PredicateRegistry.registerThrowing((Item)WeaponRegistry.DRAUPNIR_SPEAR.get());
        PredicateRegistry.registerOtherModIsLoaded((Item)WeaponRegistry.SOUL_REAPER.get(), "bettercombat");
        PredicateRegistry.registerOtherModIsLoaded((Item)WeaponRegistry.FORLORN_SCYTHE.get(), "bettercombat");
        PredicateRegistry.registerOtherModIsLoaded((Item)WeaponRegistry.DARKIN_SCYTHE_PRE.get(), "bettercombat");
        PredicateRegistry.registerOtherModIsLoaded((Item)WeaponRegistry.SHADOW_ASSASSIN_SCYTHE.get(), "bettercombat");
        PredicateRegistry.registerOtherModIsLoaded((Item)WeaponRegistry.DARKIN_SCYTHE_PRIME.get(), "bettercombat");
        PredicateRegistry.registerOtherModIsLoaded((Item)WeaponRegistry.KRAKEN_SLAYER.get(), "epicfight");
        PredicateRegistry.registerCharged((Item)WeaponRegistry.HOLY_MOONLIGHT_GREATSWORD.get());
        PredicateRegistry.registerCharged((Item)WeaponRegistry.HOLY_MOONLIGHT_SWORD.get());
        PredicateRegistry.registerCharged((Item)WeaponRegistry.BLUEMOON_GREATSWORD.get());
        PredicateRegistry.registerTranslucentAbility((Item)WeaponRegistry.TRANSLUCENT_SWORD.get());
        PredicateRegistry.registerTranslucentAbility((Item)WeaponRegistry.TRANSLUCENT_GLAIVE.get());
        PredicateRegistry.registerTranslucentAbility((Item)WeaponRegistry.TRANSLUCENT_DOUBLE_GREATSWORD.get());
        PredicateRegistry.registerNightActive((Item)WeaponRegistry.DRAUGR.get());
        PredicateRegistry.registerPrime((Item)WeaponRegistry.SKOFNUNG.get(), (itemStack, clientWorld, livingEntity, number) -> {
            boolean emp;
            if (itemStack.m_41720_() instanceof Skofnung && (emp = Skofnung.isEmpowered(itemStack))) {
                return 1.0f;
            }
            return 0.0f;
        });
        PredicateRegistry.registerPrime((Item)WeaponRegistry.STING.get(), (itemStack, clientWorld, livingEntity, number) -> {
            boolean emp;
            if (itemStack.m_41720_() instanceof Sting && (emp = ((Sting)itemStack.m_41720_()).isActive(itemStack))) {
                return 1.0f;
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)ItemRegistry.BOSS_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new CompassItemPropertyFunction((world, stack, entity) -> {
            if (stack.m_150930_((Item)ItemRegistry.BOSS_COMPASS.get())) {
                BossCompass item = (BossCompass)stack.m_41720_();
                return item.getStructurePos((Level)world, stack);
            }
            return null;
        }));
        PredicateRegistry.registerPrime((Item)WeaponRegistry.MASTER_SWORD.get(), (itemStack, clientWorld, livingEntity, number) -> {
            if (itemStack.m_150930_((Item)WeaponRegistry.MASTER_SWORD.get()) && livingEntity != null && livingEntity.m_21223_() >= livingEntity.m_21233_()) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    protected static void registerPrime(Item item, ItemPropertyFunction predicate) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("prime"), (ItemPropertyFunction)predicate);
    }

    protected static void registerPullAndPulling(Item item) {
        PredicateRegistry.registerPulling(item);
        PredicateRegistry.registerPull(item);
    }

    protected static void registerNightActive(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("night"), (stack, clientWorld, livingEntity, number) -> {
            if (livingEntity != null && livingEntity.m_9236_().m_6042_().f_223549_() && livingEntity.m_9236_().m_46468_() % 24000L > 13000L && livingEntity.m_9236_().m_46468_() % 24000L < 23000L) {
                if (stack.m_41785_().size() > 0) {
                    return 0.5f;
                }
                return 1.0f;
            }
            return 0.0f;
        });
    }

    protected static void registerPulling(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientWorld, livingEntity, number) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f;
        });
    }

    protected static void registerPull(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pull"), (itemStack, clientWorld, livingEntity, number) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.m_21211_() != itemStack ? 0.0f : (float)(itemStack.m_41779_() - livingEntity.m_21212_()) / (float)((IShootModProjectile)itemStack.m_41720_()).getPullTime();
        });
    }

    protected static void registerThrowing(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("throwing"), (itemStack, clientWorld, livingEntity, number) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f;
        });
    }

    protected static void registerOtherModIsLoaded(Item item, String id) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(id), (itemStack, clientWorld, livingEntity, number) -> WeaponUtil.isModLoaded(id) ? 1.0f : 0.0f);
    }

    protected static void registerCharged(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("charged"), (itemStack, clientWorld, livingEntity, number) -> {
            if (((IChargeNeeded)item).isCharged(itemStack)) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    protected static void registerCrossbowCharged(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("charged"), (stack, world, entity, seed) -> CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
    }

    public static void registerTranslucentAbility(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("invisible"), (itemStack, clientWorld, livingEntity, number) -> TranslucentWeapon.isInvisible(itemStack) ? 1.0f : 0.0f);
    }
}

