/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.server;

import com.mojang.serialization.Codec;
import java.text.DecimalFormat;
import javax.annotation.Nullable;

public record ModifierOperation(Type type, double value) {
    public static final ModifierOperation DEFAULT = new ModifierOperation(Type.ADDITION, 0.0);
    public static final Codec<ModifierOperation> CODEC = Codec.STRING.xmap(ModifierOperation::parse, ModifierOperation::toString);
    private static final String DEFAULT_NAME = "default";
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");

    public double apply(double num) {
        return this.type.apply(num, this.value);
    }

    public float apply(float num) {
        return (float)this.type.apply(num, this.value);
    }

    public int apply(int num) {
        return (int)this.type.apply(num, this.value);
    }

    public boolean matters() {
        return this != DEFAULT;
    }

    public boolean isPositive() {
        return this.type == Type.ADDITION || this.type == Type.MULTIPLICATION && this.value >= 1.0;
    }

    public ModifierOperation merge(ModifierOperation other) {
        if (this.matters() && !other.matters()) {
            return this;
        }
        if (!this.matters() && other.matters() || this.type != other.type) {
            return other;
        }
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.ADDITION, Type.SUBTRACTION -> new ModifierOperation(this.type, this.value + other.value);
            case Type.MULTIPLICATION -> new ModifierOperation(this.type, this.value * other.value);
        };
    }

    public String toString(double scale) {
        return this == DEFAULT ? DEFAULT_NAME : this.type.identifier + FORMAT.format(this.value * scale);
    }

    @Override
    public String toString() {
        return this.toString(1.0);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ModifierOperation) {
            ModifierOperation other = (ModifierOperation)obj;
            return this.type == other.type && this.value == other.value;
        }
        return false;
    }

    public static ModifierOperation parse(String str) {
        double value;
        if (str == null || str.length() < 2) {
            throw new ModifierOperationException("Found invalid string: '" + str + "'. String must be at least 2 characters.");
        }
        if (str.equals(DEFAULT_NAME)) {
            return DEFAULT;
        }
        char firstChar = str.charAt(0);
        if (Character.isDigit(firstChar)) {
            throw new ModifierOperationException("Found invalid string: '" + str + "'. Operations must be prefixed by a valid operation ('+', '-', or 'x').");
        }
        Type type = Type.fromChar(firstChar);
        if (type == null) {
            throw new ModifierOperationException("Found invalid string: '" + str + "'. Unknown operation '" + firstChar + "', valid operations are '+', '-', and 'x'.");
        }
        try {
            value = Double.parseDouble(str.substring(1));
        }
        catch (NumberFormatException e) {
            throw new ModifierOperationException("Found invalid string: '" + str + "'. ", e);
        }
        if (value < 0.0) {
            throw new ModifierOperationException("Found invalid string: '" + str + "'. Values must be positive.");
        }
        if ((type == Type.ADDITION || type == Type.SUBTRACTION) && value == 0.0) {
            return DEFAULT;
        }
        if (type == Type.MULTIPLICATION && value == 1.0) {
            return DEFAULT;
        }
        return new ModifierOperation(type, value);
    }

    public static enum Type {
        ADDITION('+'),
        SUBTRACTION('-'),
        MULTIPLICATION('x');

        private final char identifier;

        private Type(char identifier) {
            this.identifier = identifier;
        }

        public double apply(double base, double value) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case ADDITION -> base + value;
                case SUBTRACTION -> base - value;
                case MULTIPLICATION -> base * value;
            };
        }

        @Nullable
        public static Type fromChar(char identifier) {
            return switch (identifier) {
                case '+' -> ADDITION;
                case '-' -> SUBTRACTION;
                case 'x' -> MULTIPLICATION;
                default -> null;
            };
        }
    }

    public static class ModifierOperationException
    extends RuntimeException {
        public ModifierOperationException(String message) {
            super(message);
        }

        public ModifierOperationException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }
}

