/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class LockableList<T>
extends ArrayList<T> {
    private boolean locked = false;

    public void lock() {
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void trimToSize() {
        if (this.locked) {
            return;
        }
        super.trimToSize();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.locked) {
            return;
        }
        super.ensureCapacity(minCapacity);
    }

    @Override
    public T set(int index, T element) {
        if (this.locked) {
            return null;
        }
        return super.set(index, element);
    }

    @Override
    public boolean add(T t) {
        if (this.locked) {
            return false;
        }
        return super.add(t);
    }

    @Override
    public void add(int index, T element) {
        if (this.locked) {
            return;
        }
        super.add(index, element);
    }

    @Override
    public T remove(int index) {
        if (this.locked) {
            return null;
        }
        return (T)super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        if (this.locked) {
            return false;
        }
        return super.remove(o);
    }

    @Override
    public void clear() {
        if (this.locked) {
            return;
        }
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (this.locked) {
            return false;
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (this.locked) {
            return false;
        }
        return super.addAll(index, c);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (this.locked) {
            return;
        }
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.locked) {
            return false;
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.locked) {
            return false;
        }
        return super.retainAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        if (this.locked) {
            return false;
        }
        return super.removeIf(filter);
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        if (this.locked) {
            return;
        }
        super.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super T> c) {
        if (this.locked) {
            return;
        }
        super.sort(c);
    }
}

