/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.client.util;

import com.bonker.stardewfishing.client.util.Shake;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.mojang.math.Divisor;
import it.unimi.dsi.fastutil.ints.IntIterator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4d;

public class RenderUtil {
    public static void blitF(GuiGraphics guiGraphics, ResourceLocation texture, float x, float y, int uOffset, int vOffset, int uWidth, int vHeight) {
        float maxX = x + (float)uWidth;
        float maxY = y + (float)vHeight;
        float minU = (float)uOffset / 256.0f;
        float minV = (float)vOffset / 256.0f;
        float maxU = (float)(uOffset + uWidth) / 256.0f;
        float maxV = (float)(vOffset + vHeight) / 256.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, x, y, 0.0f).m_7421_(minU, minV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, x, maxY, 0.0f).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, maxX, maxY, 0.0f).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, maxX, y, 0.0f).m_7421_(maxU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void fillF(GuiGraphics guiGraphics, float pMinX, float pMinY, float pMaxX, float pMaxY, float pZ, int pColor) {
        float temp;
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        if (pMinX < pMaxX) {
            temp = pMinX;
            pMinX = pMaxX;
            pMaxX = temp;
        }
        if (pMinY < pMaxY) {
            temp = pMinY;
            pMinY = pMaxY;
            pMaxY = temp;
        }
        float alpha = (float)FastColor.ARGB32.m_13655_((int)pColor) / 255.0f;
        float red = (float)FastColor.ARGB32.m_13665_((int)pColor) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)pColor) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)pColor) / 255.0f;
        VertexConsumer vertexconsumer = guiGraphics.m_280091_().m_6299_(RenderType.m_285907_());
        vertexconsumer.m_252986_(matrix4f, pMinX, pMinY, pZ).m_85950_(red, green, blue, alpha).m_5752_();
        vertexconsumer.m_252986_(matrix4f, pMinX, pMaxY, pZ).m_85950_(red, green, blue, alpha).m_5752_();
        vertexconsumer.m_252986_(matrix4f, pMaxX, pMaxY, pZ).m_85950_(red, green, blue, alpha).m_5752_();
        vertexconsumer.m_252986_(matrix4f, pMaxX, pMinY, pZ).m_85950_(red, green, blue, alpha).m_5752_();
        guiGraphics.m_280262_();
    }

    public static void drawRotatedAround(PoseStack poseStack, float radians, float pivotX, float pivotY, Runnable runnable) {
        poseStack.m_85836_();
        poseStack.m_272245_(Axis.f_252393_.m_252961_(radians), pivotX, pivotY, 0.0f);
        runnable.run();
        poseStack.m_85849_();
    }

    public static void drawWithAlpha(float alpha, Runnable runnable) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        runnable.run();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawWithBlend(Runnable runnable) {
        RenderSystem.enableBlend();
        runnable.run();
        RenderSystem.disableBlend();
    }

    public static void drawWithShake(PoseStack poseStack, Shake shake, float partialTick, boolean doShake, Runnable runnable) {
        if (doShake) {
            poseStack.m_85836_();
            poseStack.m_252880_(shake.getXOffset(partialTick), shake.getYOffset(partialTick), 0.0f);
        }
        runnable.run();
        if (doShake) {
            poseStack.m_85849_();
        }
    }

    private static VertexConsumer vertexD(VertexConsumer vertexConsumer, Matrix4d pMatrix, double pX, double pY, double pZ) {
        Vector4d vec = pMatrix.transform(new Vector4d(pX, pY, pZ, 1.0));
        return vertexConsumer.m_5483_(vec.x(), vec.y(), vec.z());
    }

    public static void blitD(GuiGraphics guiGraphics, ResourceLocation texture, double x, double y, int uOffset, int vOffset, int uWidth, int vHeight) {
        double maxX = x + (double)uWidth;
        double maxY = y + (double)vHeight;
        float minU = (float)uOffset / 256.0f;
        float minV = (float)vOffset / 256.0f;
        float maxU = (float)(uOffset + uWidth) / 256.0f;
        float maxV = (float)(vOffset + vHeight) / 256.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4d matrix = new Matrix4d((Matrix4fc)guiGraphics.m_280168_().m_85850_().m_252922_());
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        RenderUtil.vertexD((VertexConsumer)bufferbuilder, matrix, x, y, 0.0).m_7421_(minU, minV).m_5752_();
        RenderUtil.vertexD((VertexConsumer)bufferbuilder, matrix, x, maxY, 0.0).m_7421_(minU, maxV).m_5752_();
        RenderUtil.vertexD((VertexConsumer)bufferbuilder, matrix, maxX, maxY, 0.0).m_7421_(maxU, maxV).m_5752_();
        RenderUtil.vertexD((VertexConsumer)bufferbuilder, matrix, maxX, y, 0.0).m_7421_(maxU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    private static IntIterator slices(int pTarget, int pTotal) {
        int i = Mth.m_184652_((int)pTarget, (int)pTotal);
        return new Divisor(pTarget, i);
    }

    public static void blitRepeatingF(GuiGraphics guiGraphics, ResourceLocation texture, float x, float y, int uOffset, int vOffset, int uWidth, int vHeight, int sourceWidth, int sourceHeight) {
        IntIterator intiterator = RenderUtil.slices(uWidth, sourceWidth);
        while (intiterator.hasNext()) {
            int width = intiterator.nextInt();
            int du = (sourceWidth - width) / 2;
            IntIterator iterator = RenderUtil.slices(vHeight, sourceHeight);
            while (iterator.hasNext()) {
                int height = iterator.nextInt();
                int dv = (sourceHeight - height) / 2;
                RenderUtil.blitF(guiGraphics, texture, x, y, uOffset + du, vOffset + dv, width, height);
                y += (float)height;
            }
            x += (float)width;
        }
    }

    public static void renderItemF(GuiGraphics guiGraphics, ItemStack item, float x, float y) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(x - (float)((int)x), y - (float)((int)y), 0.0f);
        guiGraphics.m_280480_(item, (int)x, (int)y);
        guiGraphics.m_280168_().m_85849_();
    }
}

