/*
 * Decompiled with CFR 0.152.
 */
package croissantnova.sanitydim.passive;

import croissantnova.sanitydim.capability.ISanity;
import croissantnova.sanitydim.config.ConfigProxy;
import croissantnova.sanitydim.passive.IPassiveSanitySource;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class Jukebox
implements IPassiveSanitySource {
    public static final List<BlockPos> JUKEBOXES = new ArrayList<BlockPos>();
    public static final List<BlockPos> UNSETTLING_JUKEBOXES = new ArrayList<BlockPos>();

    @Override
    public float get(@Nonnull ServerPlayer player, @Nonnull ISanity cap, @Nonnull ResourceLocation dim) {
        for (BlockPos blockPos : UNSETTLING_JUKEBOXES) {
            if (!(player.m_146892_().m_82554_(blockPos.m_252807_()) <= 60.0)) continue;
            return ConfigProxy.getJukeboxUnsettling(dim);
        }
        for (BlockPos blockPos : JUKEBOXES) {
            if (!(player.m_146892_().m_82554_(blockPos.m_252807_()) <= 60.0)) continue;
            return ConfigProxy.getJukeboxPleasant(dim);
        }
        return 0.0f;
    }

    public static boolean isMusicDiscUnsettling(Item disc) {
        return disc == Items.f_220217_ || disc == Items.f_42710_ || disc == Items.f_42752_;
    }

    public static void handleJukeboxStartedPlaying(BlockPos blockPos, ItemStack record) {
        if (!record.m_204117_(ItemTags.f_13158_)) {
            return;
        }
        boolean unsettling = Jukebox.isMusicDiscUnsettling(record.m_41720_());
        if (unsettling && !UNSETTLING_JUKEBOXES.contains(blockPos)) {
            UNSETTLING_JUKEBOXES.add(blockPos);
        } else if (!unsettling) {
            JUKEBOXES.add(blockPos);
        }
    }

    public static void handleJukeboxStoppedPlaying(BlockPos blockPos, ItemStack record) {
        while (JUKEBOXES.remove(blockPos)) {
        }
        while (UNSETTLING_JUKEBOXES.remove(blockPos)) {
        }
    }
}

