/*
 * Decompiled with CFR 0.152.
 */
package croissantnova.sanitydim.event;

import com.mojang.brigadier.CommandDispatcher;
import croissantnova.sanitydim.SanityMod;
import croissantnova.sanitydim.SanityProcessor;
import croissantnova.sanitydim.capability.IInnerEntityCap;
import croissantnova.sanitydim.capability.ISanity;
import croissantnova.sanitydim.capability.ISanityLevelChunk;
import croissantnova.sanitydim.capability.InnerEntityCapImplProvider;
import croissantnova.sanitydim.capability.SanityLevelChunkProvider;
import croissantnova.sanitydim.capability.SanityProvider;
import croissantnova.sanitydim.client.SoundPlayback;
import croissantnova.sanitydim.command.SanityCommand;
import croissantnova.sanitydim.entity.InnerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.TradeWithVillagerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public class EventHandler {
    @SubscribeEvent
    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(ISanity.class);
        event.register(IInnerEntityCap.class);
        event.register(ISanityLevelChunk.class);
    }

    @SubscribeEvent
    public void attachEntityCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(SanityProvider.KEY, (ICapabilityProvider)new SanityProvider());
        } else if (event.getObject() instanceof InnerEntity) {
            event.addCapability(InnerEntityCapImplProvider.KEY, (ICapabilityProvider)new InnerEntityCapImplProvider());
        }
    }

    @SubscribeEvent
    public void attachLevelCaps(AttachCapabilitiesEvent<LevelChunk> event) {
        event.addCapability(SanityLevelChunkProvider.KEY, (ICapabilityProvider)new SanityLevelChunkProvider());
    }

    @SubscribeEvent
    public void tickPlayer(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            SanityProcessor.tickPlayer(sp);
        }
    }

    @SubscribeEvent
    public void tickLevel(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            SanityProcessor.tickLevel(sl);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            SanityProcessor.handlePlayerHurt(player, event.getAmount());
        } else {
            livingEntity = event.getEntity();
            if (livingEntity instanceof Animal) {
                Animal animal = (Animal)livingEntity;
                livingEntity = event.getSource().m_7639_();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    SanityProcessor.handlePlayerHurtAnimal(player, animal, event.getAmount());
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        TamableAnimal ta;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof TamableAnimal && (ta = (TamableAnimal)livingEntity).m_21805_() != null) {
            SanityProcessor.handlePlayerPetDeath(ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(ta.m_21805_()), ta);
        }
    }

    @SubscribeEvent
    public void onPlayerGotAdvancement(AdvancementEvent.AdvancementEarnEvent event) {
        SanityProcessor.handlePlayerGotAdvancement((ServerPlayer)event.getEntity(), event.getAdvancement());
    }

    @SubscribeEvent
    public void onPlayerBredAnimals(BabyEntitySpawnEvent event) {
        Player player = event.getCausedByPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            SanityProcessor.handlePlayerBredAnimals(sp);
        }
    }

    @SubscribeEvent
    public void onSleepFinished(SleepFinishedTimeEvent event) {
        LevelAccessor levelAccessor;
        if (!event.getLevel().m_5776_() && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)levelAccessor;
            SanityProcessor.handlePlayerSlept(sl);
        }
    }

    @SubscribeEvent
    public void onTradeWithVillager(TradeWithVillagerEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            SanityProcessor.handlePlayerTradedWithVillager(sp);
        }
    }

    @SubscribeEvent
    public void onPlayerUsedItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)livingEntity;
            SanityProcessor.handlePlayerUsedItem(sp, event.getItem());
        }
    }

    @SubscribeEvent
    public void onItemFished(ItemFishedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            SanityProcessor.handlePlayerFishedItem(sp);
        }
    }

    @SubscribeEvent
    public void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            SanityProcessor.handlePlayerTrampledFarmland(sp);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            SanityProcessor.handlePlayerChangedDimensions(sp);
        }
    }

    @SubscribeEvent
    public void onPlayerStruckByLightning(EntityStruckByLightningEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            SanityProcessor.handlePlayerStruckByLightning(sp);
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        SanityMod.LOGGER.info("Registering sanity command...");
        SanityCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onVanillaGameEvent(VanillaGameEvent event) {
        if (event.getVanillaEvent() == GameEvent.f_157797_) {
            Vec3 pos = event.getEventPosition();
            BlockPos bPos = BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_);
            event.getLevel().m_46745_(bPos).getCapability(SanityLevelChunkProvider.CAP).ifPresent(slc -> slc.getArtificiallyPlacedBlocks().add(bPos));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void tickLocalPlayer(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.END && event.player instanceof LocalPlayer) {
            SoundPlayback.playSounds((LocalPlayer)event.player);
            SanityMod.getInstance().getGui().tick(Minecraft.m_91087_().getPartialTick());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void localLevelLoad(LevelEvent.Load event) {
        if (event.getLevel() instanceof ClientLevel) {
            SoundPlayback.onClientLevelLoad((ClientLevel)event.getLevel());
        }
    }
}

