/*
 * Decompiled with CFR 0.152.
 */
package croissantnova.sanitydim.client;

import croissantnova.sanitydim.capability.ISanity;
import croissantnova.sanitydim.capability.SanityProvider;
import croissantnova.sanitydim.config.ConfigProxy;
import croissantnova.sanitydim.sound.HeartbeatSoundInstance;
import croissantnova.sanitydim.sound.InsanitySoundInstance;
import croissantnova.sanitydim.util.MathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.Vec3;

public class SoundPlayback {
    private static InsanitySoundInstance insanity;
    private static HeartbeatSoundInstance heartbeat;
    private static float insanityTarget;
    private static float heartbeatTarget;
    private static float insanityStart;
    private static float heartbeatStart;
    private static int insanityProgress;
    private static int heartbeatProgress;
    private static int stepCd;
    private static int currentStepCd;
    private static int miscCd;
    private static SoundType currentStepSoundType;
    private static BlockPos currentStepBlockPos;
    private static final int INSANITY_I11N_TIME = 20;
    private static final int HEARTBEAT_I11N_TIME = 60;
    private static final SoundEvent[] MISC_SOUNDS;
    public static final int STEP_COOLDOWN_MIN = 600;
    public static final int STEP_COOLDOWN_MAX = 1200;
    public static final int MISC_COOLDOWN_MIN = 800;
    public static final int MISC_COOLDOWN_MAX = 1400;
    public static final RandomSource RAND;

    private static BlockPos pickFakeStepPos(LocalPlayer player) {
        Vec3 backVec = player.m_20182_().m_82549_(player.m_20154_().m_82542_(-2.0, -2.0, -2.0));
        return new BlockPos((int)backVec.f_82479_, (int)backVec.f_82480_, (int)backVec.f_82481_);
    }

    private static void playFakeSteps(LocalPlayer player, ISanity cap) {
        if (--stepCd <= 0) {
            stepCd = RAND.m_188503_(600) + 600;
            if (cap.getSanity() >= 0.4f) {
                stepCd = (int)((float)stepCd * (1.0f - MathHelper.clampNorm(Mth.m_184655_((float)cap.getSanity(), (float)0.4f, (float)0.9f)) * 0.4f));
                currentStepSoundType = player.m_20075_().m_60827_();
                currentStepBlockPos = SoundPlayback.pickFakeStepPos(player);
                currentStepCd = (RAND.m_188503_(3) + 2) * 7;
            }
        }
        if (--miscCd <= 0) {
            miscCd = RAND.m_188503_(600) + 800;
            if (cap.getSanity() >= 0.4f) {
                miscCd = (int)((float)miscCd * (1.0f - MathHelper.clampNorm(Mth.m_184655_((float)cap.getSanity(), (float)0.4f, (float)0.8f)) * 0.5f));
                SoundEvent sound = MISC_SOUNDS[RAND.m_188503_(MISC_SOUNDS.length)];
                player.m_9236_().m_245747_(SoundPlayback.pickFakeStepPos(player), sound, SoundSource.AMBIENT, 1.0f, 0.5f, false);
            }
        }
        if (currentStepCd > 0) {
            if (currentStepCd % 7 == 0) {
                player.m_9236_().m_245747_(currentStepBlockPos, currentStepSoundType.m_56776_(), SoundSource.AMBIENT, currentStepSoundType.m_56773_() * 0.5f, currentStepSoundType.m_56774_(), false);
            }
            --currentStepCd;
        }
    }

    public static void playSounds(LocalPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_() || !ConfigProxy.getPlaySounds(player.m_9236_().m_46472_().m_135782_())) {
            if (insanity != null) {
                insanity.doStop();
            }
            if (heartbeat != null) {
                heartbeat.doStop();
            }
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (insanity == null || insanity.m_7801_()) {
            insanity = new InsanitySoundInstance();
            mc.m_91106_().m_120367_((SoundInstance)insanity);
        }
        if (heartbeat == null || heartbeat.m_7801_()) {
            heartbeat = new HeartbeatSoundInstance();
            mc.m_91106_().m_120367_((SoundInstance)heartbeat);
        }
        player.getCapability(SanityProvider.CAP).ifPresent(cap -> {
            float insanityFactor = MathHelper.clampNorm(Mth.m_184655_((float)cap.getSanity(), (float)0.55f, (float)0.8f));
            float heartbeatFactor = MathHelper.clampNorm(Mth.m_184655_((float)cap.getSanity(), (float)0.7f, (float)0.8f));
            if (Math.abs(insanityFactor - insanityTarget) >= 0.05f) {
                insanityTarget = insanityFactor;
                insanityStart = SoundPlayback.insanity.factor;
                insanityProgress = 0;
            } else if (insanityProgress <= 20) {
                insanityTarget = insanityFactor;
            } else {
                SoundPlayback.insanity.factor = insanityFactor;
            }
            if (Math.abs(heartbeatFactor - heartbeatTarget) >= 0.05f) {
                heartbeatTarget = heartbeatFactor;
                heartbeatStart = SoundPlayback.heartbeat.factor;
                heartbeatProgress = 0;
            } else if (heartbeatProgress <= 60) {
                heartbeatTarget = heartbeatFactor;
            } else {
                SoundPlayback.heartbeat.factor = heartbeatFactor;
            }
            if (insanityProgress <= 20) {
                SoundPlayback.insanity.factor = Mth.m_14179_((float)((float)insanityProgress / 20.0f), (float)insanityStart, (float)insanityTarget);
                ++insanityProgress;
            }
            if (heartbeatProgress <= 60) {
                SoundPlayback.heartbeat.factor = Mth.m_14179_((float)((float)heartbeatProgress / 60.0f), (float)heartbeatStart, (float)heartbeatTarget);
                ++heartbeatProgress;
            }
            insanity.setPos(player.m_146892_());
            heartbeat.setPos(player.m_146892_());
            SoundPlayback.playFakeSteps(player, cap);
        });
    }

    public static void onClientLevelLoad(ClientLevel level) {
        insanity = null;
        heartbeat = null;
    }

    static {
        MISC_SOUNDS = new SoundEvent[]{SoundEvents.f_11837_, SoundEvents.f_12512_, SoundEvents.f_12423_, SoundEvents.f_12383_, SoundEvents.f_12598_, SoundEvents.f_12614_, SoundEvents.f_11899_, SoundEvents.f_12037_, SoundEvents.f_11749_, SoundEvents.f_11747_, SoundEvents.f_12627_, SoundEvents.f_12629_, SoundEvents.f_12619_};
        RAND = RandomSource.m_216327_();
        stepCd = RAND.m_188503_(600) + 600;
        miscCd = RAND.m_188503_(600) + 800;
    }
}

